/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.task;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Log;
import de.sormuras.bach.Task;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.Realm;
import de.sormuras.bach.util.Paths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

public class SanityTask
implements Task {
    @Override
    public void execute(Bach bach) {
        Log log = bach.getLog();
        Project project = bach.getProject();
        List<Realm> list = project.structure().realms();
        if (list.isEmpty()) {
            throw SanityTask.error(log, "No realm configured in project", new Object[0]);
        }
        Path path2 = project.folder().base();
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            throw SanityTask.error(log, "Base must be a directory: %s", path2.toUri());
        }
        if (Paths.list(path2, path -> true).isEmpty()) {
            throw SanityTask.error(log, "Base directory is empty: %s", path2.toUri());
        }
    }

    private static Error error(Log log, String string, Object ... objectArray) {
        return new AssertionError((Object)log.warning(string, objectArray).message());
    }
}

