/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.task;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Log;
import de.sormuras.bach.project.Library;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.Unit;
import de.sormuras.bach.util.Maven;
import de.sormuras.bach.util.Modules;
import de.sormuras.bach.util.Uris;
import java.io.BufferedReader;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.net.URI;
import java.net.http.HttpClient;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

class Resolver {
    private final Log log;
    private final Project project;
    private final Path lib;
    private final Library library;

    Resolver(Bach bach) {
        this.log = bach.getLog();
        this.project = bach.getProject();
        this.lib = this.project.folder().lib();
        this.library = this.project.structure().library();
    }

    public void resolve() throws Exception {
        Modules.Survey survey = Modules.Survey.of(ModuleFinder.ofSystem());
        Map<String, Set<ModuleDescriptor.Version>> map = this.findMissingModules(survey);
        if (map.isEmpty()) {
            this.log.debug("All required modules are locatable.", new Object[0]);
            return;
        }
        Downloader downloader = new Downloader();
        do {
            downloader.loadMissingModules(map);
            map.clear();
            Modules.Survey survey2 = Modules.Survey.of(ModuleFinder.of(this.lib));
            survey2.putAllRequiresTo(map);
            survey2.declaredModules().forEach(map::remove);
            survey.declaredModules().forEach(map::remove);
        } while (!map.isEmpty());
    }

    Map<String, Set<ModuleDescriptor.Version>> findMissingModules(Modules.Survey survey) {
        List<Path> list = this.project.structure().units().stream().map(Unit::info).collect(Collectors.toList());
        Modules.Survey survey2 = Modules.Survey.of(list);
        Modules.Survey survey3 = Modules.Survey.of(ModuleFinder.of(this.lib));
        this.log.debug("Project modules survey of %s unit(s) -> %s", list.size(), list);
        this.log.debug("  declared -> " + survey2.declaredModules(), new Object[0]);
        this.log.debug("  requires -> " + survey2.requiredModules(), new Object[0]);
        this.log.debug("Library modules survey of -> %s", this.lib.toUri());
        this.log.debug("  declared -> " + survey3.declaredModules(), new Object[0]);
        this.log.debug("  requires -> " + survey3.requiredModules(), new Object[0]);
        this.log.debug("System contains %d modules.", survey.declaredModules().size());
        TreeMap<String, Set<ModuleDescriptor.Version>> treeMap = new TreeMap<String, Set<ModuleDescriptor.Version>>();
        survey2.putAllRequiresTo(treeMap);
        survey3.putAllRequiresTo(treeMap);
        if (this.library.addMissingJUnitTestEngines()) {
            Library.addJUnitTestEngines(treeMap);
        }
        if (this.library.addMissingJUnitPlatformConsole()) {
            Library.addJUnitPlatformConsole(treeMap);
        }
        survey2.declaredModules().forEach(treeMap::remove);
        survey3.declaredModules().forEach(treeMap::remove);
        survey.declaredModules().forEach(treeMap::remove);
        return treeMap;
    }

    private class Downloader {
        HttpClient http = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
        Uris uris;
        Maven maven;
        Properties moduleUriProperties;

        Downloader() throws Exception {
            this.uris = new Uris(Resolver.this.log, this.http);
            this.maven = this.createMaven(this.uris);
            this.moduleUriProperties = this.load(new Properties(), Resolver.this.lib.resolve("module-uri.properties"));
        }

        void loadMissingModules(Map<String, Set<ModuleDescriptor.Version>> map) throws Exception {
            Resolver.this.log.debug("Loading modules: %s", map);
            for (Map.Entry<String, Set<ModuleDescriptor.Version>> entry : map.entrySet()) {
                Object object;
                Object object2;
                String string = entry.getKey();
                String string2 = this.moduleUriProperties.getProperty(string);
                if (string2 != null) {
                    object2 = URI.create(string2);
                    object = Resolver.this.lib.resolve(string + ".jar");
                    this.uris.copy((URI)object2, (Path)object, StandardCopyOption.COPY_ATTRIBUTES);
                    continue;
                }
                object2 = entry.getValue();
                object = this.singleton((Collection)object2).map(Object::toString).orElse(this.maven.version(string));
                String[] stringArray = this.maven.lookup(string, (String)object).split(":");
                String string3 = stringArray[0];
                String string4 = stringArray[1];
                String string5 = (String)Resolver.this.library.mavenRepositoryMapper().apply(string3, object);
                this.uris.copy(this.maven.toUri(string5, string3, string4, (String)object), Resolver.this.lib.resolve(string + "-" + (String)object + ".jar"), StandardCopyOption.COPY_ATTRIBUTES);
            }
        }

        Maven createMaven(Uris uris) throws Exception {
            Path path = Files.createDirectories(Path.of(System.getProperty("user.home"), new String[0]).resolve(".bach/modules"), new FileAttribute[0]);
            Path path2 = uris.copy(URI.create("https://github.com/sormuras/modules/raw/master/module-maven.properties"), path.resolve("module-maven.properties"), StandardCopyOption.COPY_ATTRIBUTES);
            Maven.Lookup lookup = new Maven.Lookup(Resolver.this.library.mavenGroupColonArtifactMapper(), this.map(this.load(new Properties(), Resolver.this.lib.resolve("module-maven.properties"))), this.map(this.load(new Properties(), path2)));
            Path path3 = uris.copy(URI.create("https://github.com/sormuras/modules/raw/master/module-version.properties"), path.resolve("module-version.properties"), StandardCopyOption.COPY_ATTRIBUTES);
            Maven.Lookup lookup2 = new Maven.Lookup(Resolver.this.library.mavenVersionMapper(), this.map(this.load(new Properties(), Resolver.this.lib.resolve("module-version.properties"))), this.map(this.load(new Properties(), path3)));
            return new Maven(Resolver.this.log, uris, lookup, lookup2);
        }

        Properties load(Properties properties, Path path) {
            if (Files.isRegularFile(path, new LinkOption[0])) {
                try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                    properties.load(bufferedReader);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Reading properties failed: " + path, exception);
                }
            }
            return properties;
        }

        Map<String, String> map(Properties properties) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : properties.stringPropertyNames()) {
                hashMap.put(string, properties.getProperty(string));
            }
            return Map.copyOf(hashMap);
        }

        <T> Optional<T> singleton(Collection<T> collection) {
            if (collection.isEmpty()) {
                return Optional.empty();
            }
            if (collection.size() != 1) {
                throw new IllegalStateException("Too many elements: " + collection);
            }
            return Optional.of(collection.iterator().next());
        }
    }
}

