/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.task;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Call;
import de.sormuras.bach.project.Folder;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.Realm;
import de.sormuras.bach.project.Source;
import de.sormuras.bach.project.Unit;
import de.sormuras.bach.util.Paths;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class Hydra {
    private final Bach bach;
    private final Realm realm;
    private final Folder folder;
    private final Path classes;

    public Hydra(Bach bach, Realm realm) {
        this.bach = bach;
        this.realm = realm;
        this.folder = bach.getProject().folder();
        this.classes = this.folder.realm(realm.name(), new String[0]).resolve("classes/hydra");
    }

    public void compile(List<Unit> list) {
        for (Unit unit : list) {
            if (!unit.isMultiRelease()) continue;
            this.compile(unit);
        }
    }

    private void compile(Unit unit) {
        Source source = unit.sources().get(0);
        this.bach.getLog().debug("Base feature release number is: %d", source.release());
        for (Source source2 : unit.sources()) {
            this.compile(unit, source, source2);
        }
        this.jarModule(unit);
        this.jarSources(unit);
    }

    private void compile(Unit unit, Source source, Source source2) {
        Project project = this.bach.getProject();
        String string = unit.name();
        Path path = this.classes.resolve(source.path().getFileName()).resolve(string);
        Path path2 = this.classes.resolve(source2.path().getFileName());
        Call call = new Call("javac", new String[0]).add("--release", source2.release());
        if (Files.isRegularFile(source2.path().resolve("module-info.java"), new LinkOption[0])) {
            call.forEach(this.realm.argumentsFor("javac"), Call::add).add("-d", path2).add("--module-version", project.version(unit)).add("--module-path", this.realm.modulePaths()).add("--module-source-path", source2.path().toString().replace(string, "*"));
            if (source != source2) {
                call.add("--patch-module", string + "=" + path);
            }
            call.add("--module", string);
        } else {
            Path path3;
            call.add("-d", path2.resolve(string));
            ArrayList<Path> arrayList = new ArrayList<Path>();
            if (source != source2) {
                arrayList.add(path);
            }
            if (Files.isDirectory(path3 = this.folder.modules(this.realm.name(), new String[0]), new LinkOption[0])) {
                arrayList.addAll(Paths.list(path3, Paths::isJarFile));
            }
            for (Path path4 : Paths.filterExisting(this.realm.modulePaths())) {
                if (Paths.isJarFile(path4)) {
                    arrayList.add(path4);
                    continue;
                }
                arrayList.addAll(Paths.list(path4, Paths::isJarFile));
            }
            call.add("--class-path", arrayList);
            call.forEach(Paths.find(List.of(source2.path()), Paths::isJavaFile), Call::add);
        }
        this.bach.execute(call);
    }

    private void jarModule(Unit unit) {
        ArrayDeque<Source> arrayDeque = new ArrayDeque<Source>(unit.sources());
        Path path2 = arrayDeque.pop().path().getFileName();
        String string = unit.name();
        Path path3 = this.bach.getProject().modularJar(unit);
        Call call2 = new Call("jar", new String[0]).add("--create").add("--file", path3).iff(this.bach.isVerbose(), call -> call.add("--verbose")).add("-C", this.classes.resolve(path2).resolve(string)).add(".").forEach(unit.resources(), (call, path) -> call.add("-C", path).add("."));
        for (Source source : arrayDeque) {
            Path path4 = source.path().getFileName();
            Path path5 = this.classes.resolve(path4).resolve(string);
            if (source.isVersioned()) {
                call2.add("--release", source.release());
            }
            call2.add("-C", path5);
            call2.add(".");
        }
        Paths.createDirectories(this.folder.modules(unit.realm().name(), new String[0]));
        this.bach.execute(call2);
        if (this.bach.isVerbose()) {
            this.bach.execute(new Call("jar", "--describe-module", "--file", path3.toString()));
        }
    }

    private void jarSources(Unit unit) {
        Path path2 = this.bach.getProject().sourcesJar(unit);
        ArrayDeque<Source> arrayDeque = new ArrayDeque<Source>(unit.sources());
        Call call2 = new Call("jar", new String[0]).add("--create").add("--file", path2).iff(this.bach.isVerbose(), call -> call.add("--verbose")).add("--no-manifest").add("-C", arrayDeque.removeFirst().path()).add(".").forEach(unit.resources(), (call, path) -> call.add("-C", path).add("."));
        for (Source source : arrayDeque) {
            call2.add("--release", source.release());
            call2.add("-C", source.path());
            call2.add(".");
        }
        this.bach.execute(call2);
    }
}

