/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.project;

import de.sormuras.bach.project.Realm;
import de.sormuras.bach.project.Source;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Unit {
    private final Realm realm;
    private final ModuleDescriptor descriptor;
    private final Path info;
    private final Path pom;
    private final List<Source> sources;
    private final List<Path> resources;
    private final List<Path> patches;

    public Unit(Realm realm, ModuleDescriptor moduleDescriptor, Path path, Path path2, List<Source> list, List<Path> list2, List<Path> list3) {
        this.realm = Objects.requireNonNull(realm, "realm");
        this.descriptor = Objects.requireNonNull(moduleDescriptor, "descriptor");
        this.info = Objects.requireNonNull(path, "info");
        this.pom = path2;
        this.sources = List.copyOf(list);
        this.resources = List.copyOf(list2);
        this.patches = List.copyOf(list3);
    }

    public Realm realm() {
        return this.realm;
    }

    public ModuleDescriptor descriptor() {
        return this.descriptor;
    }

    public String name() {
        return this.descriptor.name();
    }

    public Path info() {
        return this.info;
    }

    public Optional<Path> mavenPom() {
        return this.pom != null && Files.isRegularFile(this.pom, new LinkOption[0]) ? Optional.of(this.pom) : Optional.empty();
    }

    public List<Source> sources() {
        return this.sources;
    }

    public <T> List<T> sources(Function<Source, T> function) {
        return this.sources.stream().map(function).collect(Collectors.toList());
    }

    public List<Path> resources() {
        return this.resources;
    }

    public List<Path> patches() {
        return this.patches;
    }

    public String toString() {
        return this.descriptor.toNameAndVersion();
    }

    public boolean isMultiRelease() {
        return !this.sources.isEmpty() && this.sources.stream().allMatch(Source::isTargeted);
    }
}

