/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.project;

import de.sormuras.bach.util.Paths;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Realm {
    private final String name;
    private final Set<Modifier> modifiers;
    private final List<Path> sourcePaths;
    private final List<Path> modulePaths;
    private final Map<String, List<String>> argumentsFor;

    public Realm(String string, Set<Modifier> set, List<Path> list, List<Path> list2, Map<String, List<String>> map) {
        this.name = string;
        this.modifiers = set.isEmpty() ? Set.of() : EnumSet.copyOf(set);
        this.sourcePaths = List.copyOf(list);
        this.modulePaths = List.copyOf(list2);
        this.argumentsFor = Map.copyOf(map);
    }

    public String name() {
        return this.name;
    }

    public Set<Modifier> modifiers() {
        return this.modifiers;
    }

    public boolean isDeployRealm() {
        return this.modifiers.contains((Object)Modifier.DEPLOY);
    }

    public boolean isTestRealm() {
        return this.modifiers.contains((Object)Modifier.TEST);
    }

    public List<Path> sourcePaths() {
        return this.sourcePaths;
    }

    public List<Path> modulePaths() {
        return this.modulePaths;
    }

    public String moduleSourcePath() {
        return Paths.join(this.sourcePaths).replace("{MODULE}", "*");
    }

    public List<String> argumentsFor(String string) {
        return this.argumentsFor.getOrDefault(string, List.of());
    }

    public static enum Modifier {
        DEPLOY,
        TEST;

    }
}

