/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.project;

import de.sormuras.bach.Log;
import de.sormuras.bach.project.Deployment;
import de.sormuras.bach.project.Folder;
import de.sormuras.bach.project.Library;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.Realm;
import de.sormuras.bach.project.Source;
import de.sormuras.bach.project.Structure;
import de.sormuras.bach.project.Unit;
import de.sormuras.bach.util.Modules;
import de.sormuras.bach.util.Paths;
import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;

public class ProjectBuilder {
    private final Log log;

    public ProjectBuilder(Log log) {
        this.log = log;
    }

    public Project auto(Path path) {
        return this.auto(Folder.of(path));
    }

    public Project auto(Folder folder) {
        return this.auto(folder, this.properties(folder));
    }

    public Project auto(Folder folder, Properties properties) {
        String string = Optional.ofNullable(folder.base().toAbsolutePath().getFileName()).map(Path::toString).orElse(Property.NAME.defaultValue);
        String string2 = Property.NAME.get(properties, string);
        String string3 = Property.VERSION.get(properties);
        Structure structure = this.structure(folder, properties);
        Deployment deployment = this.deployment(properties);
        return new Project(string2, ModuleDescriptor.Version.parse(string3), structure, deployment);
    }

    public Properties properties(Folder folder) {
        String string = System.getProperty("project.properties", ".bach/project.properties");
        return Paths.load(new Properties(), folder.base().resolve(string));
    }

    public Deployment deployment(Properties properties) {
        String string = Property.DEPLOYMENT_REPOSITORY_ID.get(properties);
        String string2 = Property.DEPLOYMENT_URL.get(properties);
        return string == null || string2 == null ? null : new Deployment(string, URI.create(string2));
    }

    public Structure structure(Folder folder, Properties properties) {
        if (!Files.isDirectory(folder.base(), new LinkOption[0])) {
            throw new IllegalArgumentException("Not a directory: " + folder.base());
        }
        Path path2 = folder.src();
        List<Path> list = Paths.find(Set.of(path2), Paths::isModuleFile);
        if (list.isEmpty()) {
            throw new IllegalStateException("No module declared: " + path2);
        }
        if (list.stream().allMatch(path -> path.getNameCount() == 3)) {
            Realm realm2 = new Realm("realm", Set.of(), List.of(path2), List.of(folder.lib()), Map.of());
            ArrayList<Unit> arrayList = new ArrayList<Unit>();
            for (Path path3 : Paths.list(path2, path -> Files.isDirectory(path, new LinkOption[0]))) {
                this.log.debug("root = %s", path3);
                String string = path3.getFileName().toString();
                if (!SourceVersion.isName(string.replace(".", "")) || !Paths.isModuleFile(path3.resolve("module-info.java"))) continue;
                Path path4 = path3.resolve("module-info.java");
                ModuleDescriptor moduleDescriptor = Modules.describe(Paths.readString(path4));
                Path path5 = path3.resolve("pom.xml");
                List<Source> list2 = List.of(Source.of(path3, new Source.Modifier[0]));
                Unit unit2 = new Unit(realm2, moduleDescriptor, path4, path5, list2, List.of(), List.of());
                arrayList.add(unit2);
            }
            return new Structure(folder, Library.of(), List.of(realm2), arrayList);
        }
        Realm realm3 = new Realm("main", Set.of(Realm.Modifier.DEPLOY), List.of(folder.src("{MODULE}/main/java")), List.of(folder.lib()), Map.of("javac", Property.REALM_MAIN_JAVAC_ARGS.list(properties, "\\|")));
        Realm realm4 = new Realm("test", Set.of(Realm.Modifier.TEST), List.of(folder.src("{MODULE}/test/java"), folder.src("{MODULE}/test/module")), List.of(folder.modules("main", new String[0]), folder.lib()), Map.of("javac", Property.REALM_TEST_JAVAC_ARGS.list(properties, "\\|")));
        List<Realm> list3 = List.of(realm3, realm4);
        this.log.debug("realms = %s", list3);
        TreeMap treeMap = new TreeMap();
        list3.forEach(realm -> treeMap.put(realm.name(), new ArrayList()));
        ArrayList<Unit> arrayList = new ArrayList<Unit>();
        for (Path path6 : Paths.list(path2, path -> Files.isDirectory(path, new LinkOption[0]))) {
            Object object;
            List<Path> list4;
            this.log.debug("root = %s", path6);
            String string = path6.getFileName().toString();
            if (!SourceVersion.isName(string.replace(".", ""))) continue;
            this.log.debug("module = %s", string);
            List<Path> list5 = Paths.find(Set.of(path6), Paths::isModuleFile);
            if (list5.isEmpty()) continue;
            int n = arrayList.size();
            if (Files.isDirectory(path6.resolve("main"), new LinkOption[0])) {
                list4 = Paths.filterExisting(List.of(path6.resolve("main/resources")));
                object = this.unit(path6, realm3, list4, List.of());
                ((List)treeMap.get("main")).add(string);
                arrayList.add((Unit)object);
            }
            if (Files.isDirectory(path6.resolve("test"), new LinkOption[0])) {
                list4 = Paths.filterExisting(List.of(path6.resolve("test/resources"), path6.resolve("main/resources")));
                object = new ArrayList();
                if (((List)treeMap.get("main")).contains(string)) {
                    ((ArrayList)object).add(path6.resolve("main/java"));
                }
                Unit unit3 = this.unit(path6, realm4, list4, (List<Path>)object);
                ((List)treeMap.get("test")).add(string);
                arrayList.add(unit3);
            }
            if (n != arrayList.size()) continue;
            this.log.warning("Ignoring %s -- it's tree layout is not supported: %s", path6, list5);
        }
        Set set = arrayList.stream().map(Unit::name).collect(Collectors.toSet());
        arrayList.sort(Comparator.comparingLong(unit -> this.countProjectInternalRequires((Unit)unit, set)));
        this.log.debug("units = %s", arrayList);
        return new Structure(folder, Library.of(), list3, arrayList);
    }

    private long countProjectInternalRequires(Unit unit, Set<String> set) {
        return unit.descriptor().requires().stream().filter(requires -> set.contains(requires.name())).count();
    }

    private Path info(Path path) {
        for (String string : List.of("java", "module")) {
            Path path2 = path.resolve(string).resolve("module-info.java");
            if (!Paths.isJavaFile(path2)) continue;
            return path2;
        }
        throw new IllegalArgumentException("Couldn't find module-info.java file in: " + path);
    }

    private Unit unit(Path path, Realm realm, List<Path> list, List<Path> list2) {
        String string = path.getFileName().toString();
        Path path2 = path.resolve(realm.name());
        Path path3 = path2.resolve("maven/pom.xml");
        this.log.debug("pom = %s", path3);
        this.log.debug("resources = %s", list);
        this.log.debug("patches = %s", list2);
        if (Files.isDirectory(path2.resolve("java"), new LinkOption[0])) {
            Path path4 = this.info(path2);
            ModuleDescriptor moduleDescriptor = Modules.describe(Paths.readString(path4));
            List<Source> list3 = List.of(Source.of(path2.resolve("java"), new Source.Modifier[0]));
            this.log.debug("info = %s", path4);
            this.log.debug("descriptor = %s", moduleDescriptor);
            this.log.debug("sources = %s", list3);
            return new Unit(realm, moduleDescriptor, path4, path3, list3, list, list2);
        }
        if (!Paths.list(path2, "java-*").isEmpty()) {
            Path path5 = null;
            ModuleDescriptor moduleDescriptor = null;
            ArrayList<Source> arrayList = new ArrayList<Source>();
            for (int i = 7; i <= Runtime.version().feature(); ++i) {
                Path path6 = path2.resolve("java-" + i);
                if (Files.notExists(path6, new LinkOption[0])) continue;
                this.log.debug("sourced = %s", path6);
                arrayList.add(Source.of(path6, i));
                Path path7 = path6.resolve("module-info.java");
                if (path5 != null || !Paths.isJavaFile(path7)) continue;
                path5 = path7;
                moduleDescriptor = Modules.describe(Paths.readString(path5));
            }
            this.log.debug("info = %s", path5);
            this.log.debug("descriptor = %s", moduleDescriptor);
            this.log.debug("sources = %s", arrayList);
            return new Unit(realm, moduleDescriptor, path5, path3, arrayList, list, list2);
        }
        throw new IllegalArgumentException("Unknown unit layout: " + string + " <- " + path.toUri());
    }

    public static enum Property {
        NAME("project"),
        VERSION("0"),
        REALM_MAIN_JAVAC_ARGS(String.join((CharSequence)"|", "-encoding", "UTF-8", "-parameters", "-Werror", "-Xlint")),
        REALM_TEST_JAVAC_ARGS(String.join((CharSequence)"|", "-encoding", "UTF-8", "-parameters", "-Werror", "-Xlint:-preview")),
        DEPLOYMENT_REPOSITORY_ID(null),
        DEPLOYMENT_URL(null);

        final String key = this.name().toLowerCase().replace('_', '.');
        final String defaultValue;

        private Property(String string2) {
            this.defaultValue = string2;
        }

        public String get(Properties properties) {
            return this.get(properties, this.defaultValue);
        }

        public String get(Properties properties, String string) {
            return properties.getProperty(this.key, string);
        }

        public List<String> list(Properties properties, String string) {
            String string2 = this.get(properties);
            if (string2.isBlank()) {
                return List.of();
            }
            return Arrays.stream(string2.split(string)).map(String::strip).collect(Collectors.toList());
        }
    }
}

