/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.project;

import java.lang.module.ModuleDescriptor;
import java.net.URI;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class Library {
    private final Set<Modifier> modifiers;
    private final Function<String, URI> moduleMapper;
    private final BinaryOperator<String> mavenRepositoryMapper;
    private final UnaryOperator<String> mavenGroupColonArtifactMapper;
    private final UnaryOperator<String> mavenVersionMapper;

    public static Library of() {
        return new Library(EnumSet.allOf(Modifier.class), string -> null, Library::defaultRepository, string -> null, string -> null);
    }

    public static String defaultRepository(String string, String string2) {
        return string2.endsWith("SNAPSHOT") ? "https://oss.sonatype.org/content/repositories/snapshots" : "https://repo1.maven.org/maven2";
    }

    public static void addJUnitTestEngines(Map<String, Set<ModuleDescriptor.Version>> map) {
        if (map.containsKey("org.junit.jupiter") || map.containsKey("org.junit.jupiter.api")) {
            map.putIfAbsent("org.junit.jupiter.engine", Set.of());
        }
        if (map.containsKey("junit")) {
            map.putIfAbsent("org.junit.vintage", Set.of());
        }
    }

    public static void addJUnitPlatformConsole(Map<String, Set<ModuleDescriptor.Version>> map) {
        if (map.containsKey("org.junit.jupiter.engine") || map.containsKey("org.junit.vintage")) {
            map.putIfAbsent("org.junit.platform.console", Set.of());
        }
    }

    Library(Set<Modifier> set, Function<String, URI> function, BinaryOperator<String> binaryOperator, UnaryOperator<String> unaryOperator, UnaryOperator<String> unaryOperator2) {
        this.modifiers = set.isEmpty() ? Set.of() : EnumSet.copyOf(set);
        this.moduleMapper = function;
        this.mavenRepositoryMapper = binaryOperator;
        this.mavenGroupColonArtifactMapper = unaryOperator;
        this.mavenVersionMapper = unaryOperator2;
    }

    public Set<Modifier> modifiers() {
        return this.modifiers;
    }

    public Function<String, URI> moduleMapper() {
        return this.moduleMapper;
    }

    public BinaryOperator<String> mavenRepositoryMapper() {
        return this.mavenRepositoryMapper;
    }

    public UnaryOperator<String> mavenGroupColonArtifactMapper() {
        return this.mavenGroupColonArtifactMapper;
    }

    public UnaryOperator<String> mavenVersionMapper() {
        return this.mavenVersionMapper;
    }

    public boolean addMissingJUnitTestEngines() {
        return this.modifiers.contains((Object)Modifier.ADD_MISSING_JUNIT_TEST_ENGINES);
    }

    public boolean addMissingJUnitPlatformConsole() {
        return this.modifiers.contains((Object)Modifier.ADD_MISSING_JUNIT_PLATFORM_CONSOLE);
    }

    public static enum Modifier {
        ADD_MISSING_JUNIT_TEST_ENGINES,
        ADD_MISSING_JUNIT_PLATFORM_CONSOLE;

    }
}

