/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach.project;

import java.io.File;
import java.nio.file.Path;

public class Folder {
    private final Path base;
    private final Path src;
    private final Path lib;
    private final Path out;
    private final Path log;

    public static Folder of() {
        return Folder.of(Path.of("", new String[0]));
    }

    public static Folder of(Path path) {
        return new Folder(path, path.resolve("src"), path.resolve("lib"), path.resolve(".bach/out"));
    }

    public Folder(Path path, Path path2, Path path3, Path path4) {
        this.base = path;
        this.src = path2;
        this.lib = path3;
        this.out = path4;
        this.log = path4.resolve("log");
    }

    static Path resolve(Path path, String ... stringArray) {
        if (stringArray.length == 0) {
            return path;
        }
        return path.resolve(String.join((CharSequence)File.separator, stringArray));
    }

    public Path base() {
        return this.base;
    }

    public Path out() {
        return this.out;
    }

    public Path out(String ... stringArray) {
        return Folder.resolve(this.out, stringArray);
    }

    public Path lib() {
        return this.lib;
    }

    public Path src() {
        return this.src;
    }

    public Path src(String ... stringArray) {
        return Folder.resolve(this.src, stringArray);
    }

    public Path log() {
        return this.log;
    }

    public Path log(String ... stringArray) {
        return Folder.resolve(this.log, stringArray);
    }

    public Path realm(String string, String ... stringArray) {
        return Folder.resolve(this.out.resolve(string), stringArray);
    }

    public Path modules(String string, String ... stringArray) {
        return Folder.resolve(this.realm(string, "modules"), stringArray);
    }
}

