/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.util.Paths;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class Call {
    final String name;
    final List<String> arguments;

    public Call(String string, String ... stringArray) {
        this.name = string;
        this.arguments = new ArrayList<String>(List.of(stringArray));
    }

    public Call(Call call) {
        this.name = call.name;
        this.arguments = new ArrayList<String>(call.arguments);
    }

    public Call add(Object object) {
        this.arguments.add(object.toString());
        return this;
    }

    public Call add(String string, Object object) {
        return this.add(string).add(object);
    }

    public Call add(String string, List<Path> list) {
        if (list.isEmpty()) {
            return this;
        }
        return this.add(string).add(Paths.join(list));
    }

    public <T> Call forEach(Iterable<T> iterable, BiConsumer<Call, T> biConsumer) {
        iterable.forEach(object -> biConsumer.accept(this, object));
        return this;
    }

    public Call iff(boolean bl, Consumer<Call> consumer) {
        if (bl) {
            consumer.accept(this);
        }
        return this;
    }

    public <T> Call iff(Optional<T> optional, BiConsumer<Call, T> biConsumer) {
        optional.ifPresent(object -> biConsumer.accept(this, object));
        return this;
    }

    public Call clone() {
        return new Call(this);
    }

    public String[] toArray(boolean bl) {
        return (String[])(bl ? this.toList(true) : this.arguments).toArray(String[]::new);
    }

    public List<String> toList(boolean bl) {
        if (!bl) {
            return List.copyOf(this.arguments);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1 + this.arguments.size());
        arrayList.add(this.name);
        arrayList.addAll(this.arguments);
        return List.copyOf(arrayList);
    }

    public String toString() {
        return "Call{name='" + this.name + "', arguments=" + this.arguments + "}";
    }
}

