/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.Call;
import de.sormuras.bach.Log;
import de.sormuras.bach.Task;
import de.sormuras.bach.project.Project;
import de.sormuras.bach.project.ProjectBuilder;
import de.sormuras.bach.util.Tools;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.spi.ToolProvider;

public class Bach {
    private final Log log;
    private final Project project;
    private final Tools tools;

    public static void main(String ... stringArray) {
        Log log = Log.ofSystem();
        Path path = Path.of(".", new String[0]).normalize();
        Project project = new ProjectBuilder(log).auto(path);
        Bach.build(log, project);
    }

    public static void build(Log log, Project project) {
        Bach bach = new Bach(log, project);
        bach.execute(Task.build());
    }

    public Bach(Log log, Project project) {
        this.log = log;
        this.project = project;
        this.tools = new Tools();
        String string = Optional.ofNullable(this.getClass().getModule().getDescriptor()).map(ModuleDescriptor::toNameAndVersion).orElse("UNNAMED MODULE");
        log.debug("Bach.java (%s) initialized.", string);
    }

    public Log getLog() {
        return this.log;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isVerbose() {
        return this.log.verbose;
    }

    public void execute(Task ... taskArray) {
        try {
            for (Task task : taskArray) {
                String string = task.getClass().getSimpleName();
                try (Log.Context context = this.log.context(task);){
                    Log.Entry entry = this.log.debug("Executing task: %s", string);
                    context.task().execute(this);
                    long l = Duration.between(entry.instant(), Instant.now()).toMillis();
                    this.log.debug("%s took %d millis.", string, l);
                }
            }
        }
        catch (Exception exception) {
            throw new Error("Task failed to execute: " + exception, exception);
        }
    }

    public void execute(Call ... callArray) {
        for (Call call : callArray) {
            int n = this.run(call);
            if (n == 0) continue;
            throw new Error("Call exited with non-zero exit code: " + n + " <- " + call);
        }
    }

    public int run(Call call) {
        return this.run(this.tools.get(call.name), call);
    }

    public int run(ToolProvider toolProvider, Call call) {
        String string = toolProvider.name();
        CharSequence[] charSequenceArray = call.toArray(false);
        Log.Entry entry = this.log.debug("Running tool: %s %s", string, String.join((CharSequence)" ", charSequenceArray));
        int n = toolProvider.run(this.log.out, this.log.err, (String[])charSequenceArray);
        this.log.tool(string, (String[])charSequenceArray, Duration.between(entry.instant(), Instant.now()), n);
        return n;
    }
}

