/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

class Util {
    Util() {
    }

    static <E extends Comparable<E>> Set<E> concat(Set<E> set, Set<E> set2) {
        return Stream.concat(set.stream(), set2.stream()).collect(Collectors.toCollection(TreeSet::new));
    }

    static Optional<Method> findApiMethod(Class<?> clazz, String string) {
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            return Util.isApiMethod(method) ? Optional.of(method) : Optional.empty();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return Optional.empty();
        }
    }

    static List<Path> findExisting(Collection<Path> collection) {
        return collection.stream().filter(path -> Files.exists(path, new LinkOption[0])).collect(Collectors.toList());
    }

    static List<Path> findExistingDirectories(Collection<Path> collection) {
        return collection.stream().filter(path -> Files.isDirectory(path, new LinkOption[0])).collect(Collectors.toList());
    }

    static boolean isApiMethod(Method method) {
        if (method.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        return method.getParameterCount() == 0;
    }

    static List<Path> find(Collection<Path> collection, Predicate<Path> predicate) {
        ArrayList arrayList = new ArrayList();
        for (Path path : collection) {
            try {
                Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
                try {
                    stream.filter(predicate).forEach(arrayList::add);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception exception) {
                throw new Error("Walking directory '" + path + "' failed: " + exception, exception);
            }
        }
        return List.copyOf(arrayList);
    }

    static boolean isJavaFile(Path path) {
        String string;
        if (Files.isRegularFile(path, new LinkOption[0]) && (string = path.getFileName().toString()).endsWith(".java")) {
            return string.indexOf(46) == string.length() - 5;
        }
        return false;
    }

    static boolean isJarFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".jar");
    }

    static boolean isModuleInfo(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().equals("module-info.java");
    }

    static boolean isWindows() {
        return System.getProperty("os.name", "?").toLowerCase().contains("win");
    }

    static List<Path> list(Path path2) {
        return Util.list(path2, (Path path) -> true);
    }

    static List<Path> list(Path path, Predicate<Path> predicate) {
        List<Path> list;
        block8: {
            Stream<Path> stream = Files.list(path);
            try {
                list = stream.filter(predicate).sorted().collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("list directory failed: " + path, iOException);
                }
            }
            stream.close();
        }
        return list;
    }

    static List<Path> list(Path path, String string) {
        List<Path> list;
        block8: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, string);
            try {
                list = StreamSupport.stream(directoryStream.spliterator(), false).sorted().collect(Collectors.toList());
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("list directory using glob failed: " + path, iOException);
                }
            }
            directoryStream.close();
        }
        return list;
    }

    static Properties load(Properties properties, Path path) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
                properties.load(bufferedReader);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException("Reading properties failed: " + path, iOException);
            }
        }
        return properties;
    }

    static Optional<String> findFileName(URI uRI) {
        String string = uRI.getPath();
        return string == null ? Optional.empty() : Optional.of(string.substring(string.lastIndexOf(47) + 1));
    }

    static Optional<String> findFileName(Path path) {
        return Optional.ofNullable(path.toAbsolutePath().getFileName()).map(Path::toString);
    }

    static Optional<String> findVersion(String string) {
        if (!string.endsWith(".jar")) {
            return Optional.empty();
        }
        String string2 = string.substring(0, string.length() - 4);
        Matcher matcher = Pattern.compile("-(\\d+(\\.|$))").matcher(string2);
        return matcher.find() ? Optional.of(string2.substring(matcher.start() + 1)) : Optional.empty();
    }

    static Path require(Path path, Predicate<Path> predicate) {
        if (predicate.test(path)) {
            return path;
        }
        throw new IllegalArgumentException("Path failed test: " + path);
    }

    static <C extends Collection<?>> C requireNonEmpty(C c, String string) {
        if (Util.requireNonNull(c, string + " must not be null").isEmpty()) {
            throw new IllegalArgumentException(string + " must not be empty");
        }
        return c;
    }

    static <T> T requireNonNull(T t, String string) {
        return Objects.requireNonNull(t, string + " must not be null");
    }

    static <T> Optional<T> singleton(Collection<T> collection) {
        if (collection.isEmpty()) {
            return Optional.empty();
        }
        if (collection.size() != 1) {
            throw new IllegalStateException("Too many elements: " + collection);
        }
        return Optional.of(collection.iterator().next());
    }

    static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
    }

    static Path treeCreate(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("create directories failed: " + path, iOException);
        }
        return path;
    }

    static void treeDelete(Path path2) {
        Util.treeDelete(path2, path -> true);
    }

    static void treeDelete(Path path3, Predicate<Path> predicate) {
        if (predicate.test(path3)) {
            try {
                Files.deleteIfExists(path3);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try (Stream<Path> stream = Files.walk(path3, new FileVisitOption[0]);){
            Stream<Path> stream2 = stream.filter(predicate).sorted((path, path2) -> -path.compareTo((Path)path2));
            for (Path path4 : stream2.collect(Collectors.toList())) {
                Files.deleteIfExists(path4);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("tree delete failed: " + path3, iOException);
        }
    }

    static class Downloader {
        private final PrintWriter out;
        private final PrintWriter err;
        private final HttpClient client;

        Downloader(PrintWriter printWriter, PrintWriter printWriter2) {
            this(printWriter, printWriter2, HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build());
        }

        private Downloader(PrintWriter printWriter, PrintWriter printWriter2, HttpClient httpClient) {
            this.out = printWriter;
            this.err = printWriter2;
            this.client = httpClient;
        }

        Set<Path> download(Path path, Collection<Item> collection) {
            Util.treeCreate(path);
            return ((Stream)collection.stream().parallel()).map(item -> this.download(item.uri, path.resolve(item.file))).collect(Collectors.toCollection(TreeSet::new));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Path download(URI uRI, Path path) {
            block17: {
                Object object;
                Object object2;
                if ("file".equals(uRI.getScheme())) {
                    try {
                        return Files.copy(Path.of(uRI), path, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("copy file failed:" + uRI, exception);
                    }
                }
                HttpRequest.Builder builder = HttpRequest.newBuilder(uRI).GET();
                if (Files.exists(path, new LinkOption[0])) {
                    try {
                        object2 = (byte[])Files.getAttribute(path, "user:etag", new LinkOption[0]);
                        object = StandardCharsets.UTF_8.decode(ByteBuffer.wrap((byte[])object2)).toString();
                        builder.setHeader("If-None-Match", (String)object);
                    }
                    catch (Exception exception) {
                        this.err.println("Couldn't get 'user:etag' file attribute: " + exception);
                    }
                }
                try {
                    Object object3;
                    Object object4;
                    object2 = HttpResponse.BodyHandlers.ofFile(path);
                    object = this.client.send(builder.build(), object2);
                    if (object.statusCode() != 200) break block17;
                    Optional<String> optional = object.headers().firstValue("etag");
                    if (optional.isPresent()) {
                        try {
                            object4 = optional.get();
                            Files.setAttribute(path, "user:etag", StandardCharsets.UTF_8.encode((String)object4), new LinkOption[0]);
                        }
                        catch (Exception exception) {
                            this.err.println("Couldn't set 'user:etag' file attribute: " + exception);
                        }
                    }
                    if (((Optional)(object4 = object.headers().firstValue("last-modified"))).isPresent()) {
                        try {
                            object3 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
                            long l = ((DateFormat)object3).parse((String)((Optional)object4).get()).getTime();
                            FileTime fileTime = FileTime.fromMillis(l == 0L ? System.currentTimeMillis() : l);
                            Files.setLastModifiedTime(path, fileTime);
                        }
                        catch (Exception exception) {
                            this.err.println("Couldn't set last modified file attribute: " + exception);
                        }
                    }
                    object3 = this.out;
                    synchronized (object3) {
                        this.out.println(path + " <- " + uRI);
                    }
                }
                catch (IOException | InterruptedException exception) {
                    this.err.println("Failed to load: " + uRI + " -> " + exception);
                    exception.printStackTrace(this.err);
                }
            }
            return path;
        }

        static class Item {
            private final URI uri;
            private final String file;

            static Item of(URI uRI, String string) {
                return new Item(uRI, string);
            }

            private Item(URI uRI, String string) {
                this.uri = uRI;
                this.file = string;
            }
        }
    }
}

