/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Project;
import de.sormuras.bach.Util;
import java.lang.module.Configuration;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.spi.ToolProvider;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

class Tester {
    private final Bach bach;
    private final Project.Realm test;

    Tester(Bach bach, Project.Realm realm) {
        this.bach = bach;
        this.test = realm;
    }

    void test() {
        this.bach.log("Launching all test modules in realm: %s", this.test.name);
        this.test(this.test.names());
    }

    void test(Iterable<String> iterable) {
        this.bach.log("Launching all tests in realm " + this.test, new Object[0]);
        for (String string : iterable) {
            this.bach.log("%n%n%n%s%n%n%n", string);
            Optional<Project.ModuleUnit> optional = this.test.unit(string);
            if (optional.isEmpty()) {
                this.bach.warn("No test module unit available for: %s", string);
                continue;
            }
            this.test(optional.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(Project.ModuleUnit moduleUnit) {
        Project.Target target = this.bach.project.target(this.test);
        List<Path> list = this.bach.project.modulePaths(target, target.modularJar(moduleUnit));
        ModuleLayer moduleLayer = this.layer(list, moduleUnit.name());
        StringBuilder stringBuilder = new StringBuilder();
        try {
            stringBuilder.append(new ToolProviderTester(moduleLayer, moduleUnit).test());
            stringBuilder.append(new JUnitConsoleTester(moduleLayer, moduleUnit).test());
        }
        finally {
            if (Util.isWindows()) {
                System.gc();
                Util.sleep(1234L);
            }
        }
        if (stringBuilder.toString().replace('0', ' ').isBlank()) {
            return;
        }
        throw new AssertionError((Object)"Test run failed!");
    }

    private ModuleLayer layer(List<Path> list, String string) {
        this.bach.log("Module path:", new Object[0]);
        for (Path iterable2 : list) {
            this.bach.log("  -> %s", iterable2);
        }
        ModuleFinder moduleFinder = ModuleFinder.of((Path[])list.toArray(Path[]::new));
        this.bach.log("Finder finds module(s):", new Object[0]);
        moduleFinder.findAll().stream().sorted(Comparator.comparing(ModuleReference::descriptor)).forEach(moduleReference -> this.bach.log("  -> %s", moduleReference));
        List<String> list2 = List.of(string);
        this.bach.log("Root module(s):", new Object[0]);
        for (String string2 : list2) {
            this.bach.log("  -> %s", string2);
        }
        ModuleLayer moduleLayer = ModuleLayer.boot();
        Configuration configuration = moduleLayer.configuration().resolveAndBind(moduleFinder, ModuleFinder.of(new Path[0]), list2);
        ClassLoader classLoader = ClassLoader.getPlatformClassLoader();
        ModuleLayer.Controller controller = ModuleLayer.defineModulesWithOneLoader(configuration, List.of(moduleLayer), classLoader);
        return controller.layer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(ToolProvider toolProvider, String ... stringArray) {
        ClassLoader classLoader = toolProvider.getClass().getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader classLoader2 = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        for (ClassLoader classLoader3 = classLoader; classLoader3 != null; classLoader3 = classLoader3.getParent()) {
            classLoader3.setDefaultAssertionStatus(true);
        }
        try {
            this.bach.log("Running %s %s", toolProvider.name(), String.join((CharSequence)" ", stringArray));
            int n = toolProvider.run(this.bach.out, this.bach.err, stringArray);
            return n;
        }
        finally {
            thread.setContextClassLoader(classLoader2);
        }
    }

    class ToolProviderTester {
        private final ModuleLayer layer;
        private final Project.ModuleUnit unit;

        ToolProviderTester(ModuleLayer moduleLayer, Project.ModuleUnit moduleUnit) {
            this.layer = moduleLayer;
            this.unit = moduleUnit;
        }

        int test() {
            String string = "test(" + this.unit.name() + ")";
            ServiceLoader<ToolProvider> serviceLoader = ServiceLoader.load(this.layer, ToolProvider.class);
            List list = StreamSupport.stream(serviceLoader.spliterator(), false).filter(toolProvider -> toolProvider.name().equals(string)).collect(Collectors.toList());
            if (list.isEmpty()) {
                Tester.this.bach.log("No tool provider named '%s' found in: %s", string, this.layer);
                return 0;
            }
            int n = 0;
            for (ToolProvider toolProvider2 : list) {
                n += Tester.this.run(toolProvider2, new String[0]);
            }
            return n;
        }
    }

    class JUnitConsoleTester {
        private final ModuleLayer layer;
        private final Project.ModuleUnit unit;

        JUnitConsoleTester(ModuleLayer moduleLayer, Project.ModuleUnit moduleUnit) {
            this.layer = moduleLayer;
            this.unit = moduleUnit;
        }

        int test() {
            ServiceLoader<ToolProvider> serviceLoader = ServiceLoader.load(this.layer, ToolProvider.class);
            Optional<ToolProvider> optional = StreamSupport.stream(serviceLoader.spliterator(), false).filter(toolProvider -> toolProvider.name().equals("junit")).findFirst();
            if (optional.isEmpty()) {
                Tester.this.bach.warn("No tool provider named 'junit' for %s found in: %s", this.unit.name(), this.layer);
                return 0;
            }
            return Tester.this.run(optional.get(), "--select-module", this.unit.name());
        }
    }
}

