/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.Bach;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.spi.ToolProvider;

public interface Task
extends Consumer<Bach> {
    public static List<Task> of(Bach bach, Collection<String> collection) {
        bach.log("Parsing argument(s): %s", collection);
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>(collection);
        ArrayList<Task> arrayList = new ArrayList<Task>();
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        MethodType methodType = MethodType.methodType(Void.TYPE);
        while (!arrayDeque.isEmpty()) {
            String string = arrayDeque.pop();
            try {
                try {
                    lookup.findVirtual(Object.class, string, methodType);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    MethodHandle methodHandle = lookup.findVirtual(bach.getClass(), string, methodType);
                    arrayList.add(new MethodHandler(string, methodHandle));
                    continue;
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
            Optional<ToolProvider> optional = ToolProvider.findFirst(string);
            if (optional.isPresent()) {
                arrayList.add(new ToolRunner(optional.get(), arrayDeque));
                break;
            }
            throw new IllegalArgumentException("Unsupported task named: " + string);
        }
        return List.copyOf(arrayList);
    }

    public static class MethodHandler
    implements Task {
        private final String name;
        private final MethodHandle handle;

        MethodHandler(String string, MethodHandle methodHandle) {
            this.name = string;
            this.handle = methodHandle;
        }

        @Override
        public void accept(Bach bach) {
            try {
                bach.log("Invoking %s()...", this.name);
                this.handle.invokeExact(bach);
            }
            catch (Throwable throwable) {
                throw new AssertionError("Running method failed: " + this.name, throwable);
            }
        }

        public String toString() {
            return "MethodHandler[name=" + this.name + "]";
        }
    }

    public static class ToolRunner
    implements Task {
        private final ToolProvider tool;
        private final String name;
        private final String[] arguments;

        ToolRunner(ToolProvider toolProvider, Collection<?> collection) {
            this.tool = toolProvider;
            this.name = toolProvider.name();
            this.arguments = (String[])collection.stream().map(Object::toString).toArray(String[]::new);
        }

        @Override
        public void accept(Bach bach) {
            int n = bach.run(this.tool, this.arguments);
            if (n != 0) {
                throw new AssertionError((Object)(this.name + " returned non-zero exit code: " + n));
            }
        }

        public String toString() {
            return "ToolRunner[name=" + this.name + ", arguments=" + List.of(this.arguments) + "]";
        }
    }
}

