/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Command;
import de.sormuras.bach.Project;
import de.sormuras.bach.Util;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class Scribe {
    private final Bach bach;
    private final Project project;
    private final Project.Realm realm;
    private final Project.Target target;
    private final Path javadocJar;

    public Scribe(Bach bach, Project project, Project.Realm realm) {
        this.bach = bach;
        this.project = project;
        this.realm = realm;
        this.target = project.target(realm);
        String string = project.name + "-" + project.version;
        this.javadocJar = this.target.directory.resolve(string + "-javadoc.jar");
    }

    public void document() {
        this.document(this.realm.names());
    }

    public void document(Iterable<String> iterable) {
        this.bach.log("Compiling %s realm's documentation: %s", this.realm.name, iterable);
        Path path = this.target.directory.resolve("javadoc");
        Command command = new Command("javadoc", new Object[0]).add((Object)"-d", path).add((Object)"-encoding", "UTF-8").add((Object)"-locale", "en").addIff(!this.bach.verbose(), "-quiet").add("-Xdoclint:-missing").add((Object)"--module-path", this.project.library.modulePaths).add((Object)"--module-source-path", this.realm.moduleSourcePath);
        for (Project.ModuleUnit moduleUnit : this.realm.units(Project.ModuleUnit::isMultiRelease)) {
            Project.Source source = moduleUnit.sources.get(0);
            if (moduleUnit.info.path.startsWith(source.path)) continue;
            command.add((Object)"--patch-module", moduleUnit.name() + "=" + source.path);
        }
        command.add((Object)"--module", String.join((CharSequence)",", iterable));
        this.bach.run(command);
        this.bach.run(new Command("jar", new Object[0]).add("--create").add((Object)"--file", this.javadocJar).addIff(this.bach.verbose(), "--verbose").add("--no-manifest").add((Object)"-C", path).add("."));
    }

    public void generateMavenInstallScript() {
        String string2 = String.join((CharSequence)" ", "mvn", "--batch-mode", "--no-transfer-progress", "install:install-file");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Project.ModuleUnit moduleUnit : this.realm.units) {
            if (!moduleUnit.mavenPom().isPresent()) continue;
            arrayList.add(String.join((CharSequence)" ", string2, this.generateMavenArtifactLine(moduleUnit)));
        }
        if (arrayList.isEmpty()) {
            this.bach.log("No maven-install script lines generated.", new Object[0]);
            return;
        }
        try {
            Files.write(this.bach.project.targetDirectory.resolve("maven-install.sh"), arrayList, new OpenOption[0]);
            Files.write(this.bach.project.targetDirectory.resolve("maven-install.bat"), (Iterable<? extends CharSequence>)arrayList.stream().map(string -> "call " + string).collect(Collectors.toList()), new OpenOption[0]);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Generating install script failed: " + iOException.getMessage(), iOException);
        }
    }

    public void generateMavenDeployScript() {
        Project.Deployment deployment = this.realm.toolArguments.deployment().orElseThrow();
        String string2 = "org.apache.maven.plugins:maven-deploy-plugin:3.0.0-M1:deploy-file";
        String string3 = "repositoryId=" + deployment.mavenRepositoryId;
        String string4 = "url=" + deployment.mavenUri;
        String string5 = String.join((CharSequence)" ", "mvn", "--batch-mode", "--no-transfer-progress", string2, "-D" + string3, "-D" + string4);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Project.ModuleUnit moduleUnit : this.realm.units) {
            arrayList.add(String.join((CharSequence)" ", string5, this.generateMavenArtifactLine(moduleUnit)));
        }
        String string6 = "maven-deploy-" + deployment.mavenRepositoryId;
        try {
            Files.write(this.bach.project.targetDirectory.resolve((String)string6 + ".sh"), arrayList, new OpenOption[0]);
            Files.write(this.bach.project.targetDirectory.resolve((String)string6 + ".bat"), (Iterable<? extends CharSequence>)arrayList.stream().map(string -> "call " + string).collect(Collectors.toList()), new OpenOption[0]);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Deploy failed: " + iOException.getMessage(), iOException);
        }
    }

    private String generateMavenArtifactLine(Project.ModuleUnit moduleUnit) {
        String string = "pomFile=" + Util.require(moduleUnit.mavenPom().orElseThrow(), path -> Files.isRegularFile(path, new LinkOption[0]));
        String string2 = "file=" + Util.require(this.target.modularJar(moduleUnit), Util::isJarFile);
        String string3 = "sources=" + Util.require(this.target.sourcesJar(moduleUnit), Util::isJarFile);
        String string4 = "javadoc=" + Util.require(this.javadocJar, Util::isJarFile);
        return String.join((CharSequence)" ", "-D" + string, "-D" + string2, "-D" + string3, "-D" + string4);
    }
}

