/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Modules;
import de.sormuras.bach.Project;
import de.sormuras.bach.UnmappedModuleException;
import de.sormuras.bach.Util;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;

public class Resolver {
    private final Bach bach;
    private final Project project;

    public static Scanner scan(Collection<String> collection, Iterable<String> iterable) {
        TreeMap<String, Set<ModuleDescriptor.Version>> treeMap = new TreeMap<String, Set<ModuleDescriptor.Version>>();
        for (String string : iterable) {
            int n = string.indexOf(64);
            boolean bl = n == -1;
            String string2 = bl ? string : string.substring(0, n);
            ModuleDescriptor.Version version = bl ? null : ModuleDescriptor.Version.parse(string.substring(n + 1));
            treeMap.merge(string2, bl ? Set.of() : Set.of(version), Util::concat);
        }
        return new Scanner(new TreeSet<String>(collection), treeMap);
    }

    public static Scanner scan(ModuleFinder moduleFinder) {
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeMap<String, Set<ModuleDescriptor.Version>> treeMap = new TreeMap<String, Set<ModuleDescriptor.Version>>();
        Stream<ModuleDescriptor.Requires> stream = moduleFinder.findAll().stream().map(ModuleReference::descriptor).peek(moduleDescriptor -> treeSet.add(moduleDescriptor.name())).map(ModuleDescriptor::requires).flatMap(Collection::stream).filter(requires -> !requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.STATIC));
        Resolver.merge(treeMap, stream);
        return new Scanner(treeSet, treeMap);
    }

    public static Scanner scan(String ... stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeMap<String, Set<ModuleDescriptor.Version>> treeMap = new TreeMap<String, Set<ModuleDescriptor.Version>>();
        for (String string : stringArray) {
            ModuleDescriptor moduleDescriptor = Modules.describe(string);
            treeSet.add(moduleDescriptor.name());
            Resolver.merge(treeMap, moduleDescriptor.requires().stream());
        }
        return new Scanner(treeSet, treeMap);
    }

    private static void merge(Map<String, Set<ModuleDescriptor.Version>> map, Stream<ModuleDescriptor.Requires> stream) {
        stream.filter(requires -> !requires.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.MANDATED)).forEach(requires -> map.merge(requires.name(), requires.compiledVersion().map(Set::of).orElse(Set.of()), Util::concat));
    }

    public static Scanner scan(Collection<Path> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Path path : collection) {
            if (Files.isDirectory(path, new LinkOption[0])) {
                path = path.resolve("module-info.java");
            }
            try {
                arrayList.add(Files.readString(path));
            }
            catch (IOException iOException) {
                throw new UncheckedIOException("find or read failed: " + path, iOException);
            }
        }
        return Resolver.scan(arrayList.toArray(new String[0]));
    }

    Resolver(Bach bach) {
        this.bach = bach;
        this.project = bach.project;
    }

    public void resolve() {
        Path[] pathArray = (Path[])this.project.library.modulePaths.toArray(Path[]::new);
        Scanner scanner = Resolver.scan(ModuleFinder.of(pathArray));
        this.bach.log("Library of -> %s", this.project.library.modulePaths);
        this.bach.log("  modules  -> " + scanner.modules, new Object[0]);
        this.bach.log("  requires -> " + scanner.requires, new Object[0]);
        ArrayList<Path> arrayList = new ArrayList<Path>();
        for (Project.Realm object22 : this.project.realms) {
            for (Project.ModuleUnit moduleUnit : object22.units) {
                arrayList.add(moduleUnit.info.path);
            }
        }
        Scanner scanner2 = Resolver.scan(arrayList);
        this.bach.log("Sources of -> %s", arrayList);
        this.bach.log("  modules  -> " + scanner2.modules, new Object[0]);
        this.bach.log("  requires -> " + scanner2.requires, new Object[0]);
        Scanner scanner3 = Resolver.scan(ModuleFinder.ofSystem());
        this.bach.log("System contains %d modules.", scanner3.modules.size());
        TreeMap<String, Set<ModuleDescriptor.Version>> treeMap = new TreeMap();
        treeMap.putAll(scanner2.requires);
        treeMap.putAll(scanner.requires);
        scanner2.getDeclaredModules().forEach(treeMap::remove);
        scanner.getDeclaredModules().forEach(treeMap::remove);
        scanner3.getDeclaredModules().forEach(treeMap::remove);
        if (treeMap.isEmpty()) {
            return;
        }
        Util.Downloader downloader = new Util.Downloader(this.bach.out, this.bach.err);
        Scanner.Worker worker = new Scanner.Worker(this.project, downloader);
        do {
            this.bach.log("Loading missing modules: %s", treeMap);
            ArrayList<Util.Downloader.Item> arrayList2 = new ArrayList<Util.Downloader.Item>();
            for (Map.Entry entry : treeMap.entrySet()) {
                String string = (String)entry.getKey();
                Set set = (Set)entry.getValue();
                arrayList2.add(worker.toTransferItem(string, set));
            }
            Path path = this.project.library.modulePaths.get(0);
            downloader.download(path, arrayList2);
            scanner = Resolver.scan(ModuleFinder.of(pathArray));
            treeMap = new TreeMap<String, Set<ModuleDescriptor.Version>>(scanner.requires);
            scanner.getDeclaredModules().forEach(treeMap::remove);
            scanner3.getDeclaredModules().forEach(treeMap::remove);
        } while (!treeMap.isEmpty());
    }

    public static class Scanner {
        private final Set<String> modules;
        final Map<String, Set<ModuleDescriptor.Version>> requires;

        public Scanner(Set<String> set, Map<String, Set<ModuleDescriptor.Version>> map) {
            this.modules = set;
            this.requires = map;
        }

        public Set<String> getDeclaredModules() {
            return this.modules;
        }

        public Set<String> getRequiredModules() {
            return this.requires.keySet();
        }

        public Optional<ModuleDescriptor.Version> getRequiredVersion(String string) {
            Set<ModuleDescriptor.Version> set = this.requires.get(string);
            if (set == null) {
                throw new NoSuchElementException("Module " + string + " is not mapped");
            }
            if (set.size() > 1) {
                throw new IllegalStateException("Multiple versions: " + string + " -> " + set);
            }
            return set.stream().findFirst();
        }

        static class Worker {
            final Project project;
            final Properties moduleUri;
            final Lookup moduleMaven;
            final Lookup moduleVersion;

            Worker(Project project, Util.Downloader downloader) {
                this.project = project;
                Path path = project.library.modulePaths.get(0);
                this.moduleUri = Util.load(new Properties(), path.resolve("module-uri.properties"));
                this.moduleMaven = new Lookup(downloader, path, "module-maven.properties", project.library.mavenGroupColonArtifactMapper);
                this.moduleVersion = new Lookup(downloader, path, "module-version.properties", project.library.mavenVersionMapper);
            }

            private URI getModuleUri(String string) {
                try {
                    return this.project.library.moduleMapper.apply(string);
                }
                catch (UnmappedModuleException unmappedModuleException) {
                    String string2 = this.moduleUri.getProperty(string);
                    if (string2 == null) {
                        return null;
                    }
                    return URI.create(string2);
                }
            }

            Util.Downloader.Item toTransferItem(String string2, Set<ModuleDescriptor.Version> set) {
                URI uRI = this.getModuleUri(string2);
                if (uRI != null) {
                    Optional<String> optional = Util.findFileName(uRI);
                    Optional<String> optional2 = Util.findVersion(optional.orElse(""));
                    return Util.Downloader.Item.of(uRI, string2 + optional2.map(string -> "-" + string).orElse("") + ".jar");
                }
                URI uRI2 = this.project.library.mavenRepositoryMapper.apply(string2);
                String[] stringArray = this.moduleMaven.get(string2).split(":");
                String string3 = stringArray[0];
                String string4 = stringArray[1];
                String string5 = Util.singleton(set).map(Object::toString).orElse(this.moduleVersion.get(string2));
                URI uRI3 = this.toUri(uRI2.toString(), string3, string4, string5);
                return Util.Downloader.Item.of(uRI3, string2 + "-" + string5 + ".jar");
            }

            private URI toUri(String string, String string2, String string3, String string4) {
                String string5 = string3 + "-" + string4 + ".jar";
                String string6 = String.join((CharSequence)"/", string, string2.replace('.', '/'), string3, string4, string5);
                return URI.create(string6);
            }

            static class Lookup {
                final String name;
                final Properties properties;
                final Set<Pattern> patterns;
                final UnaryOperator<String> custom;

                Lookup(Util.Downloader downloader, Path path, String string2, UnaryOperator<String> unaryOperator) {
                    this.name = string2;
                    String string3 = "https://github.com/sormuras/modules/raw/master/" + string2;
                    Path path2 = Path.of(System.getProperty("user.home"), new String[0]).resolve(".bach/modules");
                    try {
                        Files.createDirectories(path2, new FileAttribute[0]);
                    }
                    catch (IOException iOException) {
                        throw new UncheckedIOException("Creating directories failed: " + path2, iOException);
                    }
                    Path path3 = downloader.download(URI.create(string3), path2.resolve(string2));
                    Properties properties = Util.load(new Properties(), path3);
                    this.properties = Util.load(new Properties(properties), path.resolve(string2));
                    this.patterns = this.properties.keySet().stream().map(Object::toString).filter(string -> !SourceVersion.isName(string)).map(Pattern::compile).collect(Collectors.toSet());
                    this.custom = unaryOperator;
                }

                String get(String string) {
                    try {
                        return (String)this.custom.apply(string);
                    }
                    catch (UnmappedModuleException unmappedModuleException) {
                        String string2 = this.properties.getProperty(string);
                        if (string2 != null) {
                            return string2;
                        }
                        for (Pattern pattern : this.patterns) {
                            if (!pattern.matcher(string).matches()) continue;
                            return this.properties.getProperty(pattern.pattern());
                        }
                        throw new IllegalStateException("No lookup value mapped for: " + string);
                    }
                }

                public String toString() {
                    int n = this.properties.size();
                    int n2 = this.properties.stringPropertyNames().size();
                    return String.format("module properties {name: %s, size: %d, names: %d}", this.name, n, n2);
                }
            }
        }
    }
}

