/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.Project;
import de.sormuras.bach.Util;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ProjectBuilder {
    public static Project build(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected a directory but got: " + path);
        }
        return new Scanner(path).project();
    }

    static class Scanner {
        private final Path base;
        private final Properties properties;

        Scanner(Path path) {
            this.base = path;
            this.properties = Util.load(new Properties(), path.resolve(".bach").resolve(".properties"));
        }

        String get(Property property) {
            return this.get(property, property.defaultValue);
        }

        String get(Property property, String string) {
            return System.getProperty(property.key, this.properties.getProperty(property.key, string));
        }

        Project.ModuleInfo info(Path path) {
            for (String string : List.of("java", "module")) {
                Path path2 = path.resolve(string).resolve("module-info.java");
                if (!Util.isModuleInfo(path2)) continue;
                return Project.ModuleInfo.of(path2);
            }
            throw new IllegalArgumentException("Couldn't find module-info.java file in: " + path);
        }

        List<Project.ModuleUnit> units(Path path2, String string) {
            ArrayList<Project.ModuleUnit> arrayList = new ArrayList<Project.ModuleUnit>();
            for (Path path3 : Util.list(path2, path -> Files.isDirectory(path, new LinkOption[0]))) {
                Path path4;
                List<Path> list;
                List<Project.Source> list2;
                Project.ModuleInfo moduleInfo;
                Path path5 = path3.resolve(string);
                if (Files.notExists(path5, new LinkOption[0])) continue;
                if (Files.isDirectory(path5.resolve("java"), new LinkOption[0])) {
                    moduleInfo = this.info(path5);
                    list2 = List.of(Project.Source.of(path5.resolve("java")));
                    list = Util.findExistingDirectories(List.of(path5.resolve("resources")));
                    path4 = path5.resolve("maven").resolve("pom.xml");
                    arrayList.add(new Project.ModuleUnit(moduleInfo, list2, list, path4));
                    continue;
                }
                if (!Util.list(path5, "java-*").isEmpty()) {
                    moduleInfo = null;
                    list2 = new ArrayList<Project.Source>();
                    for (int i = 7; i <= Runtime.version().feature(); ++i) {
                        path4 = path5.resolve("java-" + i);
                        if (Files.notExists(path4, new LinkOption[0])) continue;
                        ((ArrayList)list2).add(Project.Source.of(path4, i, new Project.Source.Flag[0]));
                        Path path6 = path4.resolve("module-info.java");
                        if (moduleInfo != null || !Util.isModuleInfo(path6)) continue;
                        moduleInfo = Project.ModuleInfo.of(path6);
                    }
                    list = Util.findExistingDirectories(List.of(path5.resolve("resources")));
                    path4 = path5.resolve("maven").resolve("pom.xml");
                    arrayList.add(new Project.ModuleUnit(moduleInfo, list2, list, path4));
                    continue;
                }
                throw new IllegalStateException("Failed to scan module: " + path3);
            }
            return arrayList;
        }

        Project.Realm realm(String string, Project.Realm ... realmArray) {
            List<Project.ModuleUnit> list = this.units(this.base.resolve(this.get(Property.SRC_PATH)), string);
            return Project.Realm.of(string, list, realmArray);
        }

        Project project() {
            Project.Realm realm = this.realm("main", new Project.Realm[0]);
            Project.Realm realm2 = this.realm("test", realm);
            return new Project(this.base, this.base.resolve("bin"), this.get(Property.NAME, Util.findFileName(this.base).orElse(Property.NAME.defaultValue)), ModuleDescriptor.Version.parse(this.get(Property.VERSION)), new Project.Library(this.base.resolve("lib")), List.of(realm, realm2));
        }
    }

    public static enum Property {
        NAME("project"),
        VERSION("0"),
        SRC_PATH("src");

        public final String key = this.name().replace('_', '-').toLowerCase();
        public final String defaultValue;

        private Property(String string2) {
            this.defaultValue = string2;
        }
    }
}

