/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.Modules;
import de.sormuras.bach.ProjectBuilder;
import de.sormuras.bach.UnmappedModuleException;
import de.sormuras.bach.Util;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Project {
    public final Path baseDirectory;
    public final Path targetDirectory;
    public final String name;
    public final ModuleDescriptor.Version version;
    public final Library library;
    public final List<Realm> realms;

    public static Project of(Path path) {
        return ProjectBuilder.build(path);
    }

    public Project(Path path, Path path2, String string, ModuleDescriptor.Version version, Library library, List<Realm> list) {
        this.baseDirectory = Util.requireNonNull(path, "base");
        this.targetDirectory = Util.requireNonNull(path2, "targetDirectory");
        this.version = Util.requireNonNull(version, "version");
        this.name = Util.requireNonNull(string, "name");
        this.library = Util.requireNonNull(library, "library");
        this.realms = List.copyOf(Util.requireNonEmpty(list, "realms"));
    }

    public List<Path> modulePaths(Target target, Path ... pathArray) {
        ArrayList<Path> arrayList = new ArrayList<Path>(List.of(pathArray));
        if (Files.isDirectory(target.modules, new LinkOption[0])) {
            arrayList.add(target.modules);
        }
        for (Realm realm : target.realm.realms) {
            Target target2 = this.target(realm);
            if (!Files.isDirectory(target2.modules, new LinkOption[0])) continue;
            arrayList.add(target2.modules);
        }
        arrayList.addAll(Util.findExistingDirectories(this.library.modulePaths));
        return List.copyOf(arrayList);
    }

    public Target target(Realm realm) {
        return new Target(realm);
    }

    public static class Library {
        public final List<Path> modulePaths;
        public final Function<String, URI> moduleMapper;
        public final Function<String, URI> mavenRepositoryMapper;
        public final UnaryOperator<String> mavenGroupColonArtifactMapper;
        public final UnaryOperator<String> mavenVersionMapper;

        public Library(Path path) {
            this(List.of(path), UnmappedModuleException::throwForURI, string -> URI.create("https://repo1.maven.org/maven2"), UnmappedModuleException::throwForString, UnmappedModuleException::throwForString);
        }

        public Library(List<Path> list, Function<String, URI> function, Function<String, URI> function2, UnaryOperator<String> unaryOperator, UnaryOperator<String> unaryOperator2) {
            this.modulePaths = List.copyOf(Util.requireNonEmpty(list, "modulePaths"));
            this.moduleMapper = function;
            this.mavenRepositoryMapper = function2;
            this.mavenGroupColonArtifactMapper = unaryOperator;
            this.mavenVersionMapper = unaryOperator2;
        }
    }

    public class Target {
        public final Realm realm;
        public final Path directory;
        public final Path modules;

        private Target(Realm realm) {
            this.realm = realm;
            this.directory = Project.this.targetDirectory.resolve("realm").resolve(realm.name);
            this.modules = this.directory.resolve("modules");
        }

        public String file(ModuleUnit moduleUnit) {
            ModuleDescriptor moduleDescriptor = moduleUnit.info.descriptor();
            return moduleDescriptor.name() + "-" + moduleDescriptor.version().orElse(Project.this.version);
        }

        public String file(ModuleUnit moduleUnit, String string) {
            return this.file(moduleUnit) + string;
        }

        public Path modularJar(ModuleUnit moduleUnit) {
            return this.modules.resolve(this.file(moduleUnit, ".jar"));
        }

        public Path sourcesJar(ModuleUnit moduleUnit) {
            return this.directory.resolve(this.file(moduleUnit, "-sources.jar"));
        }
    }

    public static class Realm {
        public final String name;
        public final boolean preview;
        public final int release;
        public final String moduleSourcePath;
        public final ToolArguments toolArguments;
        public final List<ModuleUnit> units;
        public final List<Realm> realms;

        public static Realm of(String string, ModuleUnit moduleUnit, Realm ... realmArray) {
            String string2 = moduleUnit.info.moduleSourcePath;
            return new Realm(string, false, 0, string2, ToolArguments.of(), List.of(moduleUnit), realmArray);
        }

        public static Realm of(String string, List<ModuleUnit> list, Realm ... realmArray) {
            Stream<String> stream = list.stream().map(ModuleUnit::path).distinct();
            String string2 = stream.collect(Collectors.joining(File.pathSeparator));
            return new Realm(string, false, 0, string2, ToolArguments.of(), list, realmArray);
        }

        public Realm(String string, boolean bl, int n, String string2, ToolArguments toolArguments, List<ModuleUnit> list, Realm ... realmArray) {
            this.name = string;
            this.preview = bl;
            this.release = n;
            this.moduleSourcePath = string2;
            this.toolArguments = toolArguments;
            this.units = list;
            this.realms = List.of(realmArray);
        }

        Optional<ModuleUnit> unit(String string) {
            return this.units.stream().filter(moduleUnit -> moduleUnit.name().equals(string)).findAny();
        }

        List<String> names() {
            return this.units.stream().map(ModuleUnit::name).collect(Collectors.toList());
        }

        List<String> names(boolean bl) {
            return this.units.stream().filter(moduleUnit -> moduleUnit.isMultiRelease() == bl).map(ModuleUnit::name).collect(Collectors.toList());
        }

        public List<ModuleUnit> units(Predicate<ModuleUnit> predicate) {
            return this.units.stream().filter(predicate).collect(Collectors.toList());
        }
    }

    public static class Deployment {
        public final String mavenRepositoryId;
        public final URI mavenUri;

        public Deployment(String string, URI uRI) {
            this.mavenRepositoryId = string;
            this.mavenUri = uRI;
        }
    }

    public static class ToolArguments {
        public static final List<String> JAVAC = List.of("-encoding", "UTF-8", "-parameters", "-Xlint");
        public final List<String> javac;
        public final Deployment deployment;

        public static ToolArguments of() {
            return new ToolArguments(JAVAC, null);
        }

        public ToolArguments(List<String> list, Deployment deployment) {
            this.javac = List.copyOf(list);
            this.deployment = deployment;
        }

        public Optional<Deployment> deployment() {
            return Optional.ofNullable(this.deployment);
        }
    }

    public static class ModuleUnit {
        public final ModuleInfo info;
        public final List<Source> sources;
        public final List<Path> resources;
        public final Path mavenPom;

        public static ModuleUnit of(Path path) {
            ModuleInfo moduleInfo = ModuleInfo.of(path.resolve("module-info.java"));
            List<Source> list = List.of(Source.of(path));
            Path path2 = path.getParent();
            List<Path> list2 = Util.findExistingDirectories(List.of(path2.resolve("resources")));
            Path path3 = path2.resolve("maven").resolve("pom.xml");
            return new ModuleUnit(moduleInfo, list, list2, path3);
        }

        public ModuleUnit(ModuleInfo moduleInfo, List<Source> list, List<Path> list2, Path path) {
            this.info = Util.requireNonNull(moduleInfo, "info");
            this.sources = List.copyOf(list);
            this.resources = List.copyOf(list2);
            this.mavenPom = path;
        }

        public boolean isMultiRelease() {
            return this.sources.stream().allMatch(Source::isTargeted);
        }

        public String name() {
            return this.info.descriptor().name();
        }

        public String path() {
            return this.info.moduleSourcePath;
        }

        public Optional<Path> mavenPom() {
            return Files.isRegularFile(this.mavenPom, new LinkOption[0]) ? Optional.of(this.mavenPom) : Optional.empty();
        }
    }

    public static class Source {
        public final Path path;
        public final int release;
        public final Set<Flag> flags;

        public static Source of(Path path) {
            return new Source(path, 0, Set.of());
        }

        public static Source of(Path path, int n, Flag ... flagArray) {
            return new Source(path, n, Util.concat(Set.of(Flag.VERSIONED), Set.of(flagArray)));
        }

        public Source(Path path, int n, Set<Flag> set) {
            this.path = path;
            this.release = n;
            this.flags = Set.copyOf(set);
        }

        public boolean isTargeted() {
            return this.release != 0;
        }

        public boolean isVersioned() {
            return this.flags.contains((Object)Flag.VERSIONED);
        }

        public static enum Flag {
            VERSIONED;

        }
    }

    public static class ModuleInfo
    extends ModuleReference {
        public final Path path;
        public final String moduleSourcePath;

        public static ModuleInfo of(Path path) {
            if (!Util.isModuleInfo(path)) {
                throw new IllegalArgumentException("Expected module-info.java path, but got: " + path);
            }
            try {
                return new ModuleInfo(Modules.describe(Files.readString(path)), path);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException("Reading module declaration failed: " + path, iOException);
            }
        }

        private ModuleInfo(ModuleDescriptor moduleDescriptor, Path path) {
            super(moduleDescriptor, path.toUri());
            this.path = path;
            this.moduleSourcePath = Modules.moduleSourcePath(path, moduleDescriptor.name());
        }

        @Override
        public ModuleReader open() {
            throw new UnsupportedOperationException("Can't open a module-info.java file for reading");
        }
    }
}

