/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import java.io.File;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Modules {
    private static final Pattern MAIN_CLASS = Pattern.compile("//\\s*(?:--main-class)\\s+([\\w.]+)");
    private static final Pattern MODULE_NAME_PATTERN = Pattern.compile("(?:module)\\s+([\\w.]+)(?:\\s*/\\*.*\\*/\\s*)?\\s*\\{");
    private static final Pattern MODULE_REQUIRES_PATTERN = Pattern.compile("(?:requires)(?:\\s+[\\w.]+)?\\s+([\\w.]+)(?:\\s*/\\*\\s*([\\w.\\-+]+)\\s*\\*/\\s*)?\\s*;");
    private static final Pattern MODULE_PROVIDES_PATTERN = Pattern.compile("(?:provides)\\s+([\\w.]+)\\s+with\\s+([\\w.,\\s]+)\\s*;");

    private Modules() {
    }

    public static ModuleDescriptor describe(String string) {
        Object object;
        Object object2;
        Matcher matcher = MODULE_NAME_PATTERN.matcher(string);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Expected Java module source unit, but got: " + string);
        }
        String string2 = matcher.group(1).trim();
        ModuleDescriptor.Builder builder = ModuleDescriptor.newModule(string2);
        Matcher matcher2 = MAIN_CLASS.matcher(string);
        if (matcher2.find()) {
            object2 = matcher2.group(1);
            builder.mainClass((String)object2);
        }
        object2 = MODULE_REQUIRES_PATTERN.matcher(string);
        while (((Matcher)object2).find()) {
            object = ((Matcher)object2).group(1);
            Optional.ofNullable(((Matcher)object2).group(2)).ifPresentOrElse(arg_0 -> Modules.lambda$describe$0(builder, (String)object, arg_0), () -> Modules.lambda$describe$1(builder, (String)object));
        }
        object = MODULE_PROVIDES_PATTERN.matcher(string);
        while (((Matcher)object).find()) {
            String string3 = ((Matcher)object).group(1);
            String string4 = ((Matcher)object).group(2);
            builder.provides(string3, List.of(string4.trim().split("\\s*,\\s*")));
        }
        return builder.build();
    }

    public static String moduleSourcePath(Path path2, String string) {
        Path path3;
        Path path4 = path3 = Files.isDirectory(path2, new LinkOption[0]) ? path2 : Objects.requireNonNull(path2.getParent());
        if (Files.notExists(path3.resolve("module-info.java"), new LinkOption[0])) {
            throw new IllegalArgumentException("No 'module-info.java' file found in: " + path3);
        }
        ArrayList arrayList = new ArrayList();
        path3.forEach(path -> arrayList.add(path.toString()));
        int n = Collections.frequency(arrayList, string);
        if (n == 0) {
            return path3.toString();
        }
        if (n == 1) {
            if (path3.endsWith(string)) {
                return Optional.ofNullable(path3.getParent()).map(Path::toString).orElse(".");
            }
            Stream<String> stream = arrayList.stream().map(string2 -> string2.equals(string) ? "*" : string2);
            return String.join((CharSequence)File.separator, stream.collect(Collectors.toList()));
        }
        throw new IllegalArgumentException("Ambiguous module source path: " + path2);
    }

    private static /* synthetic */ void lambda$describe$1(ModuleDescriptor.Builder builder, String string) {
        builder.requires(string);
    }

    private static /* synthetic */ void lambda$describe$0(ModuleDescriptor.Builder builder, String string, String string2) {
        builder.requires(Set.of(), string, ModuleDescriptor.Version.parse(string2));
    }
}

