/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Command;
import de.sormuras.bach.Project;
import de.sormuras.bach.Util;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class Jigsaw {
    private final Bach bach;
    private final Project project;
    private final Project.Realm realm;
    private final Project.Target target;
    private final Path classes;

    public Jigsaw(Bach bach, Project project, Project.Realm realm) {
        this.bach = bach;
        this.project = project;
        this.realm = realm;
        this.target = project.target(realm);
        this.classes = this.target.directory.resolve("jigsaw").resolve("classes");
    }

    public void compile(Collection<String> collection) {
        this.bach.log("Compiling %s realm jigsaw modules: %s", this.realm.name, collection);
        this.bach.run(new Command("javac", new Object[0]).addEach(this.realm.toolArguments.javac).add((Object)"-d", this.classes).addIff(this.realm.preview, "--enable-preview").addIff(this.realm.release != 0, "--release", this.realm.release).add((Object)"--module-path", this.project.modulePaths(this.target, new Path[0])).add((Object)"--module-source-path", this.realm.moduleSourcePath).add((Object)"--module-version", this.project.version).addEach(this.patches(collection)).add((Object)"--module", String.join((CharSequence)",", collection)));
        for (String string : collection) {
            Project.ModuleUnit moduleUnit = this.realm.unit(string).orElseThrow();
            this.jarModule(moduleUnit);
            this.jarSources(moduleUnit);
        }
    }

    private List<String> patches(Collection<String> collection) {
        Command command = new Command("<patches>", new Object[0]);
        for (String string : collection) {
            Optional<Project.ModuleUnit> optional = this.realm.realms.stream().flatMap(realm -> realm.units.stream()).filter(moduleUnit -> moduleUnit.name().equals(string)).findFirst();
            optional.ifPresent(moduleUnit -> command.add("--patch-module", moduleUnit.sources.stream().map(source -> source.path), string2 -> string + "=" + string2));
        }
        return command.getArguments();
    }

    private void jarModule(Project.ModuleUnit moduleUnit) {
        ModuleDescriptor moduleDescriptor = moduleUnit.info.descriptor();
        this.bach.run(new Command("jar", new Object[0]).add("--create").add((Object)"--file", Util.treeCreate(this.target.modules).resolve(this.target.file(moduleUnit, ".jar"))).addIff(this.bach.verbose(), "--verbose").addIff("--module-version", moduleDescriptor.version()).addIff("--main-class", moduleDescriptor.mainClass()).add((Object)"-C", this.classes.resolve(moduleDescriptor.name())).add(".").addEach(moduleUnit.resources, (command, path) -> command.add((Object)"-C", path).add(".")));
        if (this.bach.verbose()) {
            this.bach.run(new Command("jar", "--describe-module", "--file", this.target.modularJar(moduleUnit)));
        }
    }

    private void jarSources(Project.ModuleUnit moduleUnit) {
        this.bach.run(new Command("jar", new Object[0]).add("--create").add((Object)"--file", this.target.sourcesJar(moduleUnit)).addIff(this.bach.verbose(), "--verbose").add("--no-manifest").addEach(moduleUnit.sources, (command, source) -> command.add((Object)"-C", source.path).add(".")).addEach(moduleUnit.resources, (command, path) -> command.add((Object)"-C", path).add(".")));
    }
}

