/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.Bach;
import de.sormuras.bach.Command;
import de.sormuras.bach.Project;
import de.sormuras.bach.Util;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Hydra {
    private final Bach bach;
    private final Project project;
    private final Project.Realm realm;
    private final Project.Target target;
    private final Path classes;

    public Hydra(Bach bach, Project project, Project.Realm realm) {
        this.bach = bach;
        this.project = project;
        this.realm = realm;
        this.target = project.target(realm);
        this.classes = this.target.directory.resolve("hydra").resolve("classes");
    }

    public void compile(Collection<String> collection) {
        this.bach.log("Generating commands for %s realm multi-release modules(s): %s", this.realm.name, collection);
        for (String string : collection) {
            this.compile(this.realm.unit(string).orElseThrow());
        }
    }

    private void compile(Project.ModuleUnit moduleUnit) {
        Project.Source source = moduleUnit.sources.get(0);
        this.bach.log("Base feature release number is: %d", source.release);
        for (Project.Source source2 : moduleUnit.sources) {
            this.compile(moduleUnit, source, source2);
        }
        this.jarModule(moduleUnit);
        this.jarSources(moduleUnit);
    }

    private void compile(Project.ModuleUnit moduleUnit, Project.Source source, Project.Source source2) {
        String string = moduleUnit.info.descriptor().name();
        Path path = this.classes.resolve(source.path.getFileName()).resolve(string);
        Path path2 = this.classes.resolve(source2.path.getFileName());
        Command command = new Command("javac", new Object[0]).add((Object)"--release", source2.release);
        if (Util.isModuleInfo(source2.path.resolve("module-info.java"))) {
            command.addEach(this.realm.toolArguments.javac).add((Object)"-d", path2).add((Object)"--module-version", this.project.version).add((Object)"--module-path", this.project.modulePaths(this.target, new Path[0])).add((Object)"--module-source-path", this.realm.moduleSourcePath);
            if (source != source2) {
                command.add((Object)"--patch-module", string + "=" + path);
            }
            command.add((Object)"--module", string);
        } else {
            command.add((Object)"-d", path2.resolve(string));
            ArrayList<Path> arrayList = new ArrayList<Path>();
            if (source != source2) {
                arrayList.add(path);
            }
            if (Files.isDirectory(this.target.modules, new LinkOption[0])) {
                arrayList.addAll(Util.list(this.target.modules, Util::isJarFile));
            }
            for (Path path3 : Util.findExisting(this.project.library.modulePaths)) {
                if (Util.isJarFile(path3)) {
                    arrayList.add(path3);
                    continue;
                }
                arrayList.addAll(Util.list(path3, Util::isJarFile));
            }
            command.add((Object)"--class-path", arrayList);
            command.addEach(Util.find(List.of(source2.path), Util::isJavaFile));
        }
        this.bach.run(command);
    }

    private void jarModule(Project.ModuleUnit moduleUnit) {
        ArrayDeque<Project.Source> arrayDeque = new ArrayDeque<Project.Source>(moduleUnit.sources);
        Path path2 = arrayDeque.pop().path.getFileName();
        String string = moduleUnit.info.descriptor().name();
        Command command2 = new Command("jar", new Object[0]).add("--create").add((Object)"--file", Util.treeCreate(this.target.modules).resolve(this.target.file(moduleUnit, ".jar"))).addIff(this.bach.verbose(), "--verbose").add((Object)"-C", this.classes.resolve(path2).resolve(string)).add(".").addEach(moduleUnit.resources, (command, path) -> command.add((Object)"-C", path).add("."));
        for (Project.Source source : arrayDeque) {
            Path path3 = source.path.getFileName();
            Path path4 = this.classes.resolve(path3).resolve(string);
            if (source.isVersioned()) {
                command2.add((Object)"--release", source.release);
            }
            command2.add((Object)"-C", path4);
            command2.add(".");
        }
        this.bach.run(command2);
        if (this.bach.verbose()) {
            this.bach.run(new Command("jar", "--describe-module", "--file", this.target.modularJar(moduleUnit)));
        }
    }

    private void jarSources(Project.ModuleUnit moduleUnit) {
        ArrayDeque<Project.Source> arrayDeque = new ArrayDeque<Project.Source>(moduleUnit.sources);
        Command command2 = new Command("jar", new Object[0]).add("--create").add((Object)"--file", this.target.sourcesJar(moduleUnit)).addIff(this.bach.verbose(), "--verbose").add("--no-manifest").add((Object)"-C", arrayDeque.removeFirst().path).add(".").addEach(moduleUnit.resources, (command, path) -> command.add((Object)"-C", path).add("."));
        for (Project.Source source : arrayDeque) {
            command2.add((Object)"--release", source.release);
            command2.add((Object)"-C", source.path);
            command2.add(".");
        }
        this.bach.run(command2);
    }
}

