/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Command {
    private final String name;
    private final List<String> arguments = new ArrayList<String>();

    public Command(String string, Object ... objectArray) {
        this.name = string;
        this.addEach(objectArray);
    }

    public Command(String string, Iterable<?> iterable) {
        this.name = string;
        this.addEach(iterable);
    }

    public Command clone() {
        return new Command(this.name, this.arguments);
    }

    public Command add(Object object) {
        this.arguments.add(object.toString());
        return this;
    }

    public Command add(Object object, Object object2) {
        return this.add(object).add(object2);
    }

    public Command add(Object object, Collection<Path> collection) {
        return this.add(object, collection.stream(), UnaryOperator.identity());
    }

    public Command add(Object object, Stream<Path> stream, UnaryOperator<String> unaryOperator) {
        String string = stream.map(Object::toString).collect(Collectors.joining(File.pathSeparator));
        if (string.isEmpty()) {
            return this;
        }
        return this.add(object, unaryOperator.apply(string));
    }

    public Command addEach(Object ... objectArray) {
        return this.addEach(List.of(objectArray));
    }

    public Command addEach(Iterable<?> iterable) {
        iterable.forEach(this::add);
        return this;
    }

    public Command addEach(Stream<?> stream) {
        stream.forEach(this::add);
        return this;
    }

    public <T> Command addEach(Iterable<T> iterable, BiConsumer<Command, T> biConsumer) {
        iterable.forEach(object -> biConsumer.accept(this, object));
        return this;
    }

    public Command addIff(boolean bl, Object object) {
        return bl ? this.add(object) : this;
    }

    public Command addIff(boolean bl, Object object, Object object2) {
        return bl ? this.add(object, object2) : this;
    }

    public Command addIff(Object object, Optional<?> optional) {
        return optional.isPresent() ? this.add(object, optional.get()) : this;
    }

    public Command addIff(boolean bl, Consumer<Command> consumer) {
        if (bl) {
            consumer.accept(this);
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public String toString() {
        String string = this.arguments.isEmpty() ? "<empty>" : "'" + String.join((CharSequence)"', '", this.arguments) + "'";
        return "Command{name='" + this.name + "', args=[" + string + "]}";
    }

    public String[] toStringArray() {
        return (String[])this.arguments.toArray(String[]::new);
    }

    public String toCommandLine() {
        return this.toCommandLine(" ");
    }

    public String toCommandLine(String string) {
        if (this.arguments.isEmpty()) {
            return this.name;
        }
        return this.name + string + String.join((CharSequence)string, this.arguments);
    }
}

