/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.bach;

import de.sormuras.bach.Command;
import de.sormuras.bach.Hydra;
import de.sormuras.bach.Jigsaw;
import de.sormuras.bach.Project;
import de.sormuras.bach.Resolver;
import de.sormuras.bach.Scribe;
import de.sormuras.bach.Task;
import de.sormuras.bach.Tester;
import de.sormuras.bach.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.spi.ToolProvider;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Bach {
    public static String VERSION = "1.9.2";
    final PrintWriter out;
    final PrintWriter err;
    private final boolean verbose;
    final Project project;

    public static void main(String ... stringArray) {
        Bach bach = new Bach();
        try {
            bach.main(stringArray.length == 0 ? List.of("build") : List.of(stringArray));
        }
        catch (Throwable throwable) {
            bach.err.printf("Bach.java (%s) failed: %s%n", VERSION, throwable.getMessage());
            if (bach.verbose) {
                throwable.printStackTrace(bach.err);
            }
            ArrayDeque<Throwable> arrayDeque = new ArrayDeque<Throwable>();
            for (Throwable throwable2 = throwable; throwable2 != null && !arrayDeque.contains(throwable2); throwable2 = throwable2.getCause()) {
                arrayDeque.add(throwable2);
            }
            bach.err.println(arrayDeque.getLast());
        }
    }

    public Bach() {
        this(new PrintWriter(System.out, true), new PrintWriter(System.err, true), Boolean.getBoolean("ebug") || "".equals(System.getProperty("ebug")), Project.of(Path.of("", new String[0])));
    }

    public Bach(PrintWriter printWriter, PrintWriter printWriter2, boolean bl, Project project) {
        this.out = Util.requireNonNull(printWriter, "out");
        this.err = Util.requireNonNull(printWriter2, "err");
        this.verbose = bl;
        this.project = project;
        this.log("New Bach.java (%s) instance initialized: %s", VERSION, this);
    }

    void log(String string, Object ... objectArray) {
        if (this.verbose) {
            this.out.println(String.format(string, objectArray));
        }
    }

    void warn(String string, Object ... objectArray) {
        this.err.println(String.format(string, objectArray));
    }

    void main(List<String> list) {
        List<Task> list2 = Util.requireNonEmpty(Task.of(this, list), "tasks");
        this.log("Running %d argument task(s): %s", list2.size(), list2);
        list2.forEach(task -> task.accept(this));
    }

    void run(Command command) {
        Optional<ToolProvider> optional = ToolProvider.findFirst(command.getName());
        int n = this.run(optional.orElseThrow(), command.toStringArray());
        if (n != 0) {
            throw new AssertionError((Object)("Running command failed: " + command));
        }
    }

    int run(ToolProvider toolProvider, String ... stringArray) {
        this.log("Running %s %s", toolProvider.name(), String.join((CharSequence)" ", stringArray));
        return toolProvider.run(this.out, this.err, stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String banner() {
        Module module = this.getClass().getModule();
        try (InputStream inputStream = module.getResourceAsStream("de/sormuras/bach/banner.txt");){
            if (inputStream == null) {
                String string2 = String.format("Bach.java %s (member of %s)", VERSION, module);
                return string2;
            }
            Stream<String> stream = new BufferedReader(new InputStreamReader(inputStream)).lines();
            String string3 = stream.collect(Collectors.joining(System.lineSeparator()));
            String string = string3 + " " + VERSION;
            return string;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Loading banner resource failed", iOException);
        }
    }

    boolean verbose() {
        return this.verbose;
    }

    public void help() {
        this.out.println(this.banner());
        this.out.println("Method API");
        Arrays.stream(this.getClass().getMethods()).filter(Util::isApiMethod).map(method -> "  " + method.getName() + " (" + method.getDeclaringClass().getSimpleName() + ")").sorted().forEach(this.out::println);
        this.out.println("Provided tools");
        ServiceLoader.load(ToolProvider.class).stream().map(provider -> "  " + ((ToolProvider)provider.get()).name()).sorted().forEach(this.out::println);
    }

    public void build() {
        this.info();
        this.resolve();
        long l = this.project.realms.stream().map(realm -> realm.units).mapToLong(Collection::size).sum();
        if (l == 0L) {
            throw new AssertionError((Object)("No units declared: " + this.project.realms));
        }
        ArrayDeque<Project.Realm> arrayDeque = new ArrayDeque<Project.Realm>(this.project.realms);
        Project.Realm realm2 = arrayDeque.removeFirst();
        this.compile(realm2);
        for (Project.Realm realm3 : arrayDeque) {
            this.compile(realm3);
        }
        for (Project.Realm realm3 : arrayDeque) {
            new Tester(this, realm3).test();
        }
        if (!realm2.units.isEmpty()) {
            Scribe scribe = new Scribe(this, this.project, realm2);
            scribe.document();
            scribe.generateMavenInstallScript();
            if (realm2.toolArguments.deployment().isPresent()) {
                scribe.generateMavenDeployScript();
            }
        }
        this.summary(realm2);
    }

    private void compile(Project.Realm realm) {
        List<String> list;
        if (realm.units.isEmpty()) {
            return;
        }
        List<String> list2 = realm.names(true);
        if (!list2.isEmpty()) {
            new Hydra(this, this.project, realm).compile(list2);
        }
        if (!(list = realm.names(false)).isEmpty()) {
            new Jigsaw(this, this.project, realm).compile(list);
        }
    }

    public void summary(Project.Realm realm) {
        this.out.println();
        this.out.printf("+===%n", new Object[0]);
        this.out.printf("| Project %s %s summary%n", this.project.name, this.project.version);
        this.out.printf("+===%n", new Object[0]);
        Project.Target target = this.project.target(realm);
        try {
            for (Path object2 : Util.list(target.modules, Util::isJarFile)) {
                this.out.printf("%5d %s %n", Files.size(object2), object2);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        this.out.println();
        List<Path> list = this.project.modulePaths(target, new Path[0]);
        String string = String.join((CharSequence)",", realm.names());
        Command command = new Command("jdeps", new Object[0]).add((Object)"--module-path", (Collection<Path>)list).add((Object)"--multi-release", "BASE");
        this.run(command.clone().add("-summary").add((Object)"--dot-output", target.directory.resolve("jdeps")).add((Object)"--add-modules", string));
        if (this.verbose) {
            this.run(command.clone().add((Object)"--check", string));
        }
    }

    public void info() {
        this.out.printf("Bach.java (%s)%n", VERSION);
        this.out.printf("+===%n", new Object[0]);
        this.out.printf("| Project %s %s%n", this.project.name, this.project.version);
        this.out.printf("+===%n", new Object[0]);
        try {
            for (Field field : this.project.getClass().getFields()) {
                this.out.printf("  %s = %s%n", field.getName(), field.get(this.project));
            }
            for (Project.Realm realm : this.project.realms) {
                this.out.printf("+ Realm %s%n", realm.name);
                for (Field field : realm.getClass().getFields()) {
                    this.out.printf("  %s.%s = %s%n", realm.name, field.getName(), field.get(realm));
                }
                for (Project.ModuleUnit moduleUnit : realm.units) {
                    this.out.printf("- ModuleUnit %s%n", moduleUnit.name());
                    for (Field field : moduleUnit.getClass().getFields()) {
                        this.out.printf("  (%s).%s = %s%n", moduleUnit.name(), field.getName(), field.get(moduleUnit));
                    }
                }
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace(this.err);
        }
    }

    public void resolve() {
        new Resolver(this).resolve();
    }

    public void version() {
        this.out.println(VERSION);
    }
}

