/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.parser;

import de.sonallux.spotify.core.model.SpotifyAuthorizationScopes;
import de.sonallux.spotify.core.model.SpotifyWebApi;
import de.sonallux.spotify.core.model.SpotifyWebApiCategory;
import de.sonallux.spotify.core.model.SpotifyWebApiObject;
import de.sonallux.spotify.parser.ApiEndpointParser;
import de.sonallux.spotify.parser.ApiObjectParser;
import de.sonallux.spotify.parser.ApiParseException;
import de.sonallux.spotify.parser.ApiScopesParser;
import de.sonallux.spotify.parser.ParseUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.SortedMap;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebApiParser {
    private static final Logger log = LoggerFactory.getLogger(WebApiParser.class);
    public static final String DEFAULT_WEB_API_DOCUMENTATION_URL = "https://developer.spotify.com/documentation/web-api/reference";
    public static final String DEFAULT_WEB_API_ENDPOINT_URL = "https://api.spotify.com/v1";
    private final ApiObjectParser apiObjectParser = new ApiObjectParser();
    private final ApiEndpointParser apiEndpointParser;
    private final ApiScopesParser apiScopesParser;

    public WebApiParser(boolean isInteractive) {
        this.apiEndpointParser = new ApiEndpointParser(isInteractive);
        this.apiScopesParser = new ApiScopesParser();
    }

    public SpotifyWebApi parse(Path responseTypesFile) throws IOException, ApiParseException {
        return this.parse(DEFAULT_WEB_API_DOCUMENTATION_URL, DEFAULT_WEB_API_ENDPOINT_URL, responseTypesFile);
    }

    public SpotifyWebApi parse(String documentationUrl, String endpointUrl, Path responseTypesFile) throws IOException, ApiParseException {
        Document document = Jsoup.connect((String)documentationUrl).get();
        return this.parse(documentationUrl, endpointUrl, document, responseTypesFile);
    }

    public SpotifyWebApi parse(String documentationUrl, String endpointUrl, Document document, Path responseTypesFile) throws IOException, ApiParseException {
        Elements content = document.body().selectFirst("div.post-content").children();
        List<Elements> allSections = ParseUtils.splitAt(content, "h1");
        SortedMap<String, SpotifyWebApiObject> objects = this.apiObjectParser.parseSpotifyObjects(allSections, documentationUrl);
        SortedMap<String, SpotifyWebApiCategory> categories = this.apiEndpointParser.parseSpotifyApiCategories(allSections, documentationUrl, endpointUrl, responseTypesFile);
        SpotifyAuthorizationScopes scopes = this.apiScopesParser.parseScopes();
        this.apiScopesParser.validateScopes(scopes, categories);
        return new SpotifyWebApi(documentationUrl, endpointUrl, objects, categories, scopes);
    }
}

