/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.parser;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.sonallux.spotify.core.Yaml;
import de.sonallux.spotify.core.model.SpotifyWebApiCategory;
import de.sonallux.spotify.core.model.SpotifyWebApiEndpoint;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseTypeMapper {
    private static final Logger log = LoggerFactory.getLogger(ResponseTypeMapper.class);
    private final Path responseTypesFile;
    private final Map<String, Map<String, EndpointResponse>> responseTypes;
    private final MessageDigest md5Digest;
    private final ObjectMapper objectMapper;

    ResponseTypeMapper(Path responseTypesFile) throws IOException, NoSuchAlgorithmException {
        this.responseTypesFile = responseTypesFile;
        this.objectMapper = Yaml.create();
        this.md5Digest = MessageDigest.getInstance("MD5");
        this.responseTypes = this.load();
    }

    private Map<String, Map<String, EndpointResponse>> load() throws IOException {
        try (InputStream inputStream = Files.newInputStream(this.responseTypesFile, new OpenOption[0]);){
            Map map = (Map)this.objectMapper.readValue(inputStream, (TypeReference)new TypeReference<Map<String, Map<String, EndpointResponse>>>(){});
            return map;
        }
    }

    List<SpotifyWebApiEndpoint.ResponseType> getEndpointResponseTypes(String categoryId, SpotifyWebApiEndpoint endpoint) {
        EndpointResponse endpointResponse = this.getEndpointResponse(categoryId, endpoint.getId());
        if (endpointResponse == null) {
            return null;
        }
        String currentHash = this.calculateMD5Hash(endpoint);
        if (!currentHash.equals(endpointResponse.getMd5Hash())) {
            log.warn("Response description for endpoint {} has changed", (Object)endpoint.getId());
            endpointResponse.setMd5Hash(currentHash);
        }
        return endpointResponse.getResponseTypes();
    }

    void save() throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(this.responseTypesFile, new OpenOption[0]);){
            this.objectMapper.writeValue(outputStream, this.responseTypes);
        }
    }

    void update(List<SpotifyWebApiCategory> categories) {
        Scanner scanner = new Scanner(System.in);
        for (SpotifyWebApiCategory category : categories) {
            block1: for (SpotifyWebApiEndpoint endpoint : category.getEndpointList()) {
                String currentHash = this.calculateMD5Hash(endpoint);
                EndpointResponse endpointResponse = this.getEndpointResponse(category.getId(), endpoint.getId());
                if (endpointResponse != null && endpointResponse.getResponseTypes().size() != 0 && currentHash.equals(endpointResponse.getMd5Hash())) continue;
                if (endpointResponse == null) {
                    endpointResponse = new EndpointResponse();
                    this.setEndpointResponse(category.getId(), endpoint.getId(), endpointResponse);
                }
                endpointResponse.setMd5Hash(currentHash);
                System.out.printf("\nMissing response in %s for %s %s: \n%s\n", category.getId(), endpoint.getHttpMethod(), endpoint.getId(), endpoint.getResponseDescription());
                int i = 0;
                while (true) {
                    if (endpointResponse.getResponseTypes().size() > i) {
                        SpotifyWebApiEndpoint.ResponseType responseType = endpointResponse.getResponseTypes().get(i);
                        System.out.printf("Response type (current: %s): ", responseType.getType());
                        responseType.setType(ResponseTypeMapper.readString(scanner, responseType.getType()));
                        System.out.printf("Response status (current: %s): ", responseType.getStatus());
                        responseType.setStatus(ResponseTypeMapper.readInt(scanner, responseType.getStatus()));
                    } else {
                        System.out.print("Response type: ");
                        String newType = ResponseTypeMapper.readString(scanner, null);
                        if (newType == null) continue block1;
                        System.out.print("Response status (default: 200): ");
                        int newStatus = ResponseTypeMapper.readInt(scanner, 200);
                        endpointResponse.getResponseTypes().add(new SpotifyWebApiEndpoint.ResponseType(newType, newStatus, null));
                    }
                    ++i;
                }
            }
        }
    }

    private static String readString(Scanner scanner, String defaultValue) {
        String string = scanner.nextLine().trim();
        if (string.isEmpty()) {
            return defaultValue;
        }
        return string;
    }

    private static int readInt(Scanner scanner, int defaultValue) {
        try {
            return Integer.parseInt(scanner.nextLine().trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private EndpointResponse getEndpointResponse(String categoryId, String endpointId) {
        Map<String, EndpointResponse> endpointTypes = this.responseTypes.get(categoryId);
        if (endpointTypes == null) {
            return null;
        }
        return endpointTypes.get(endpointId);
    }

    private void setEndpointResponse(String categoryId, String endpointId, EndpointResponse endpointResponse) {
        Map<String, EndpointResponse> endpointTypes = this.responseTypes.get(categoryId);
        if (endpointTypes != null) {
            endpointTypes.put(endpointId, endpointResponse);
        } else {
            HashMap<String, EndpointResponse> map = new HashMap<String, EndpointResponse>();
            map.put(endpointId, endpointResponse);
            this.responseTypes.put(categoryId, map);
        }
    }

    private String calculateMD5Hash(SpotifyWebApiEndpoint endpoint) {
        this.md5Digest.reset();
        this.md5Digest.update(endpoint.getResponseDescription().getBytes(StandardCharsets.UTF_8));
        byte[] bytes = this.md5Digest.digest();
        BigInteger bigInt = new BigInteger(1, bytes);
        return bigInt.toString(16);
    }

    static class EndpointResponse {
        private String md5Hash;
        private List<SpotifyWebApiEndpoint.ResponseType> responseTypes = new ArrayList<SpotifyWebApiEndpoint.ResponseType>();

        public String getMd5Hash() {
            return this.md5Hash;
        }

        public List<SpotifyWebApiEndpoint.ResponseType> getResponseTypes() {
            return this.responseTypes;
        }

        public void setMd5Hash(String md5Hash) {
            this.md5Hash = md5Hash;
        }

        public void setResponseTypes(List<SpotifyWebApiEndpoint.ResponseType> responseTypes) {
            this.responseTypes = responseTypes;
        }

        public EndpointResponse(String md5Hash, List<SpotifyWebApiEndpoint.ResponseType> responseTypes) {
            this.md5Hash = md5Hash;
            this.responseTypes = responseTypes;
        }

        public EndpointResponse() {
        }
    }
}

