/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.parser;

import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import com.vladsch.flexmark.html2md.converter.HtmlLinkResolver;
import com.vladsch.flexmark.html2md.converter.HtmlLinkResolverFactory;
import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterContext;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Node;

class Html2Markdown {
    private static final FlexmarkHtmlConverter CONVERTER;

    Html2Markdown() {
    }

    static String convert(Node node) {
        return CONVERTER.convert(node).trim();
    }

    static String convert(List<? extends Node> nodes) {
        return nodes.stream().map(arg_0 -> ((FlexmarkHtmlConverter)CONVERTER).convert(arg_0)).collect(Collectors.joining("\n")).trim();
    }

    static {
        MutableDataSet options = new MutableDataSet();
        options.set(FlexmarkHtmlConverter.UNORDERED_LIST_DELIMITER, (Object)Character.valueOf('-'));
        CONVERTER = FlexmarkHtmlConverter.builder((DataHolder)options).linkResolverFactory((HtmlLinkResolverFactory)new HostHtmlLinkResolverFactory()).build();
    }

    private static class HostHtmlLinkResolverFactory
    implements HtmlLinkResolverFactory {
        private HostHtmlLinkResolverFactory() {
        }

        @Nullable
        public Set<Class<?>> getAfterDependents() {
            return null;
        }

        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            return null;
        }

        public boolean affectsGlobalScope() {
            return false;
        }

        public HtmlLinkResolver apply(HtmlNodeConverterContext context) {
            return new HostHtmlLinkResolver();
        }
    }

    private static class HostHtmlLinkResolver
    implements HtmlLinkResolver {
        private HostHtmlLinkResolver() {
        }

        public ResolvedLink resolveLink(Node node, HtmlNodeConverterContext context, ResolvedLink link) {
            if (link.getUrl().startsWith("/")) {
                String host = this.getHost(node.baseUri());
                return link.withUrl((CharSequence)(host + link.getUrl()));
            }
            return link;
        }

        private String getHost(String baseUri) {
            try {
                URL url = new URL(baseUri);
                return url.getProtocol() + "://" + url.getHost();
            }
            catch (MalformedURLException e) {
                return "";
            }
        }
    }
}

