/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.parser;

import de.sonallux.spotify.core.Yaml;
import de.sonallux.spotify.core.model.SpotifyWebApi;
import de.sonallux.spotify.parser.ApiParseException;
import de.sonallux.spotify.parser.WebApiParser;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=ManifestVersionProvider.class)
public class CLI
implements Runnable {
    @CommandLine.Option(names={"-o", "--output"}, required=true, description={"The file to output the generated api documentation"})
    Path outputFile;
    @CommandLine.Option(names={"--response-types"}, required=true, description={"The response type mappings file"})
    Path responseTypesFile;
    @CommandLine.Option(names={"-i", "--interactive"}, description={"Run parser in interactive mode"})
    boolean isInteractive = false;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Print usage help"})
    boolean helpRequested = false;
    @CommandLine.Option(names={"-v", "--version"}, versionHelp=true, description={"Print version information"})
    boolean versionRequested = false;

    @Override
    public void run() {
        SpotifyWebApi apiDocumentation = null;
        try {
            WebApiParser webApiParser = new WebApiParser(this.isInteractive);
            apiDocumentation = webApiParser.parse(this.responseTypesFile);
        }
        catch (ApiParseException | IOException e) {
            System.err.println("Failed to parse web api documentation: " + e.getMessage());
            System.exit(1);
        }
        try (OutputStream outputStream = Files.newOutputStream(this.outputFile, new OpenOption[0]);){
            Yaml.create().writeValue(outputStream, (Object)apiDocumentation);
        }
        catch (IOException e) {
            System.err.println("Failed to write output file: " + e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new CLI()).execute(args);
        System.exit(exitCode);
    }

    static class ManifestVersionProvider
    implements CommandLine.IVersionProvider {
        private static final String IMPLEMENTATION_TITLE = "spotify-web-api-parser";

        ManifestVersionProvider() {
        }

        public String[] getVersion() throws Exception {
            Enumeration<URL> resources = CLI.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try {
                    Manifest manifest = new Manifest(url.openStream());
                    Attributes attributes = manifest.getMainAttributes();
                    Object title = ManifestVersionProvider.get(attributes, "Implementation-Title");
                    if (!IMPLEMENTATION_TITLE.equals(title)) continue;
                    Object version = ManifestVersionProvider.get(attributes, "Implementation-Version");
                    return new String[]{title + " version \"" + version + "\""};
                }
                catch (IOException e) {
                    return new String[]{"Unable to read manifest from " + url + ": " + e};
                }
            }
            return new String[]{"spotify-web-api-parser version \"unknown\""};
        }

        private static Object get(Attributes attributes, String key) {
            return attributes.get(new Attributes.Name(key));
        }
    }
}

