/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.parser;

import de.sonallux.spotify.core.model.SpotifyAuthorizationScopes;
import de.sonallux.spotify.core.model.SpotifyScope;
import de.sonallux.spotify.core.model.SpotifyWebApiCategory;
import de.sonallux.spotify.core.model.SpotifyWebApiEndpoint;
import de.sonallux.spotify.parser.ApiParseException;
import de.sonallux.spotify.parser.ParseUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

class ApiScopesParser {
    private static final String DEFAULT_SCOPES_URL = "https://developer.spotify.com/documentation/general/guides/scopes";
    private String scopesUrl;

    ApiScopesParser() {
    }

    SpotifyAuthorizationScopes parseScopes() throws IOException, ApiParseException {
        return this.parseScopes(DEFAULT_SCOPES_URL);
    }

    SpotifyAuthorizationScopes parseScopes(String scopesUrl) throws IOException, ApiParseException {
        this.scopesUrl = scopesUrl;
        Document document = Jsoup.connect((String)scopesUrl).get();
        return this.parseScopes(document);
    }

    private SpotifyAuthorizationScopes parseScopes(Document document) throws ApiParseException {
        TreeMap<String, SpotifyScope> scopes = new TreeMap<String, SpotifyScope>();
        Elements content = document.body().selectFirst("div.post-content").children();
        Elements scopeElements = ParseUtils.splitAt(content, "h2").get(1);
        for (Element scopeElement : scopeElements.select("div")) {
            SpotifyScope scope = this.parseScope(scopeElement);
            if (scopes.containsKey(scope.getId())) {
                throw new ApiParseException("Scope is defined twice: " + scope.getId());
            }
            scopes.put(scope.getId(), scope);
        }
        return new SpotifyAuthorizationScopes(this.scopesUrl, scopes);
    }

    private SpotifyScope parseScope(Element scopeElement) throws ApiParseException {
        String id = scopeElement.attributes().get("id");
        String link = this.scopesUrl + "/#" + id;
        String text = scopeElement.select("h3").text();
        if (!id.equals(text)) {
            throw new ApiParseException("Scope has id " + id + " and text " + text);
        }
        Elements tableEntries = scopeElement.select("tr");
        if (tableEntries.size() != 3) {
            throw new ApiParseException("Expected three table entries for scope: " + id);
        }
        String description = ((Element)tableEntries.get(0)).child(1).text();
        String userDescription = ((Element)tableEntries.get(1)).child(1).text();
        ArrayList<SpotifyScope.EndpointLink> endpoints = new ArrayList<SpotifyScope.EndpointLink>();
        for (Element element : ((Element)tableEntries.get(2)).select("li > a")) {
            endpoints.add(this.parseEndpointLink(element));
        }
        return new SpotifyScope(id, link, description, userDescription, endpoints);
    }

    private SpotifyScope.EndpointLink parseEndpointLink(Element element) throws ApiParseException {
        String absUrl = element.absUrl("href");
        String url = element.attributes().get("href");
        String[] urlSegments = url.split("/");
        if (urlSegments.length < 3) {
            throw new ApiParseException("Unknown link for scope: " + url);
        }
        if ("web-api".equals(urlSegments[2])) {
            String endpoint = urlSegments[urlSegments.length - 1].substring(1);
            if (endpoint.length() == 0) {
                throw new ApiParseException("Scope has unknown link to web-api: " + url);
            }
            return new SpotifyScope.EndpointLink(absUrl, urlSegments[2], endpoint);
        }
        return new SpotifyScope.EndpointLink(absUrl, urlSegments[2]);
    }

    void validateScopes(SpotifyAuthorizationScopes scopes, SortedMap<String, SpotifyWebApiCategory> categories) throws ApiParseException {
        StringBuilder error = new StringBuilder();
        for (Object scope : scopes.getScopeList()) {
            for (SpotifyScope.EndpointLink link : scope.getEndpoints()) {
                Optional<SpotifyWebApiEndpoint> endpoint;
                if (link.getEndpoint() == null || !(endpoint = categories.values().stream().flatMap(c -> c.getEndpointList().stream()).filter(e -> e.getId().equals(link.getEndpoint())).findFirst()).isEmpty()) continue;
                error.append(String.format("Scope %s has unknown endpoint reference: %s", scope.getId(), link.getEndpoint())).append("\n");
            }
        }
        List endpointScopes = categories.values().stream().flatMap(c -> c.getEndpointList().stream()).flatMap(e -> e.getScopes().stream()).distinct().collect(Collectors.toList());
        for (String endpointScope : endpointScopes) {
            Optional scope = scopes.getScope(endpointScope);
            if (!scope.isEmpty()) continue;
            error.append(String.format("Endpoint has unknown scope: %s", endpointScope)).append("\n");
        }
        String errorText = error.toString();
        if (!errorText.isEmpty()) {
            throw new ApiParseException(errorText);
        }
    }
}

