/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.parser;

import de.sonallux.spotify.core.model.SpotifyWebApiObject;
import de.sonallux.spotify.parser.ApiObjectFixes;
import de.sonallux.spotify.parser.ApiParseException;
import de.sonallux.spotify.parser.Html2Markdown;
import java.util.Comparator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApiObjectParser {
    private static final Logger log = LoggerFactory.getLogger(ApiObjectParser.class);
    private String baseUrl;

    ApiObjectParser() {
    }

    SortedMap<String, SpotifyWebApiObject> parseSpotifyObjects(List<Elements> sections, String baseUrl) throws ApiParseException {
        this.baseUrl = baseUrl;
        TreeMap<String, SpotifyWebApiObject> objects = new TreeMap<String, SpotifyWebApiObject>();
        Elements objectSection = sections.get(sections.size() - 1);
        for (Element element : objectSection.select("h3")) {
            SpotifyWebApiObject object = this.parseSpotifyObject(element);
            if (objects.containsKey(object.getName())) {
                throw new ApiParseException("Object is defined twice: " + object.getName());
            }
            objects.put(object.getName(), object);
        }
        ApiObjectFixes.fixApiObjects(objects);
        for (SpotifyWebApiObject object : ApiObjectFixes.getMissingObjects()) {
            if (objects.containsKey(object.getName())) {
                log.warn("Object {} is no longer missing", (Object)object.getName());
                continue;
            }
            objects.put(object.getName(), object);
        }
        for (SpotifyWebApiObject object : objects.values()) {
            object.getProperties().sort(Comparator.comparing(SpotifyWebApiObject.Property::getName));
        }
        return objects;
    }

    private SpotifyWebApiObject parseSpotifyObject(Element objectHeader) throws ApiParseException {
        String id = objectHeader.attributes().get("id");
        String link = this.baseUrl + "/#" + id;
        String objectName = objectHeader.text();
        SpotifyWebApiObject spotifyObject = new SpotifyWebApiObject(objectName, id, link);
        for (Element prop : objectHeader.nextElementSibling().select("tbody > tr")) {
            Element nameElement = prop.selectFirst("code");
            String name = nameElement.text();
            Element brElement = nameElement.nextElementSibling();
            Elements descriptionElements = brElement.nextElementSiblings();
            String description = Html2Markdown.convert((List<? extends Node>)descriptionElements);
            String type = prop.child(1).text();
            SpotifyWebApiObject.Property property = new SpotifyWebApiObject.Property(name, type, description);
            if (spotifyObject.getProperties().contains(property)) {
                throw new ApiParseException(String.format("Property %s of Object %s is defined twice", name, objectName));
            }
            spotifyObject.addProperty(property);
        }
        return spotifyObject;
    }
}

