/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.http;

import de.sonallux.spotify.api.models.Error;

public class Response<T> {
    private final okhttp3.Response rawResponse;
    private final T body;
    private final Error error;

    public static <T> Response<T> success(T body, okhttp3.Response rawResponse) {
        return new Response<T>(rawResponse, body, null);
    }

    public static <T> Response<T> error(Error error, okhttp3.Response rawResponse) {
        return new Response<Object>(rawResponse, null, error);
    }

    public okhttp3.Response raw() {
        return this.rawResponse;
    }

    public int code() {
        return this.rawResponse.code();
    }

    public String message() {
        return this.rawResponse.message();
    }

    public boolean isSuccessful() {
        return this.rawResponse.isSuccessful();
    }

    public T body() {
        return this.body;
    }

    public Error errorBody() {
        return this.error;
    }

    private Response(okhttp3.Response rawResponse, T body, Error error) {
        this.rawResponse = rawResponse;
        this.body = body;
        this.error = error;
    }
}

