/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.authorization.implicit_grant;

import de.sonallux.spotify.api.authorization.AuthTokens;
import de.sonallux.spotify.api.authorization.AuthorizationRedirectResponse;
import de.sonallux.spotify.api.authorization.AuthorizationUrlBuilder;
import de.sonallux.spotify.api.authorization.InMemoryTokenStore;
import de.sonallux.spotify.api.authorization.TokenStore;
import de.sonallux.spotify.api.authorization.TokenStoreApiAuthorizationProvider;
import de.sonallux.spotify.api.authorization.implicit_grant.RedirectResponseBody;
import de.sonallux.spotify.api.util.TextUtil;
import okhttp3.HttpUrl;

public class ImplicitGrantFlow
extends TokenStoreApiAuthorizationProvider {
    private final String clientId;
    private final String redirectUri;

    ImplicitGrantFlow(String clientId, String redirectUri, TokenStore tokenStore) {
        super(tokenStore);
        this.clientId = clientId;
        this.redirectUri = redirectUri;
    }

    public ImplicitGrantFlow(String clientId, String redirectUri) {
        this(clientId, redirectUri, new InMemoryTokenStore());
    }

    public AuthorizationUrlBuilder createAuthorizationUrl() {
        return new AuthorizationUrlBuilder(this.clientId, this.redirectUri, "token");
    }

    public AuthorizationRedirectResponse<RedirectResponseBody> parseAuthorizationRedirectResponse(String url) {
        HttpUrl parsedHttpUrl = HttpUrl.get((String)url);
        String fragment = parsedHttpUrl.fragment();
        if (TextUtil.hasText(fragment)) {
            parsedHttpUrl = parsedHttpUrl.newBuilder().query(fragment).fragment(null).build();
        }
        return AuthorizationRedirectResponse.parse(parsedHttpUrl, httpUrl -> {
            String accessToken = httpUrl.queryParameter("access_token");
            String tokenType = httpUrl.queryParameter("token_type");
            String expiresIn = httpUrl.queryParameter("expires_in");
            if (TextUtil.hasText(accessToken) && TextUtil.hasText(tokenType) && TextUtil.hasText(expiresIn)) {
                return new RedirectResponseBody(accessToken, tokenType, Integer.parseInt(expiresIn));
            }
            return null;
        });
    }

    public void useResponse(AuthorizationRedirectResponse<RedirectResponseBody> response) {
        if (!response.isSuccess()) {
            return;
        }
        RedirectResponseBody body = response.getBody();
        AuthTokens authTokens = AuthTokens.builder().accessToken(body.getAccessToken()).tokenType(body.getTokenType()).expiresIn(body.getExpiresIn()).build();
        this.tokenStore.storeTokens(authTokens);
    }
}

