/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.authorization.authorization_code;

import de.sonallux.spotify.api.authorization.AuthTokens;
import de.sonallux.spotify.api.authorization.AuthorizationRedirectResponse;
import de.sonallux.spotify.api.authorization.AuthorizationUrlBuilder;
import de.sonallux.spotify.api.authorization.SpotifyAuthorizationException;
import de.sonallux.spotify.api.authorization.TokenStore;
import de.sonallux.spotify.api.authorization.authorization_code.AbstractAuthorizationCodeFlow;
import de.sonallux.spotify.api.authorization.authorization_code.AuthorizationCodePKCEUrlBuilder;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.util.TextUtil;
import okhttp3.HttpUrl;

public class AuthorizationCodePKCEFlow
extends AbstractAuthorizationCodeFlow {
    AuthorizationCodePKCEFlow(String clientId, String redirectUri, TokenStore tokenStore, HttpUrl tokenApiBaseUrl) {
        super(clientId, redirectUri, tokenStore, tokenApiBaseUrl);
    }

    public AuthorizationCodePKCEFlow(String clientId, String redirectUri, TokenStore tokenStore) {
        super(clientId, redirectUri, tokenStore);
    }

    public AuthorizationCodePKCEFlow(String clientId, String redirectUri) {
        super(clientId, redirectUri);
    }

    public AuthorizationUrlBuilder createAuthorizationUrl(String codeChallenge) {
        return new AuthorizationCodePKCEUrlBuilder(this.clientId, this.redirectUri, codeChallenge);
    }

    public void exchangeAuthorizationCode(AuthorizationRedirectResponse<String> authResponse, String codeVerifier) throws SpotifyAuthorizationException {
        if (!authResponse.isSuccess()) {
            throw new SpotifyAuthorizationException("Authorization failed: " + authResponse.getState());
        }
        ApiCall<AuthTokens> tokensCall = this.tokenApi.getTokensFromAuthorizationCodePKCE(this.clientId, "authorization_code", authResponse.getBody(), this.redirectUri, codeVerifier);
        this.executeAuthTokensCall(tokensCall);
    }

    @Override
    public boolean refreshAccessToken() {
        AuthTokens tokens = this.tokenStore.loadTokens();
        if (tokens == null || !TextUtil.hasText(tokens.getRefreshToken())) {
            return false;
        }
        ApiCall<AuthTokens> tokensCall = this.tokenApi.getTokensFromRefreshTokenPKCE(this.clientId, "refresh_token", tokens.getRefreshToken());
        try {
            this.executeAuthTokensCall(tokensCall);
            return true;
        }
        catch (SpotifyAuthorizationException ignore) {
            return false;
        }
    }
}

