/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.authorization.authorization_code;

import de.sonallux.spotify.api.authorization.AuthTokens;
import de.sonallux.spotify.api.authorization.AuthorizationRedirectResponse;
import de.sonallux.spotify.api.authorization.AuthorizationUrlBuilder;
import de.sonallux.spotify.api.authorization.SpotifyAuthorizationException;
import de.sonallux.spotify.api.authorization.TokenStore;
import de.sonallux.spotify.api.authorization.authorization_code.AbstractAuthorizationCodeFlow;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.util.TextUtil;
import java.util.Base64;
import okhttp3.HttpUrl;

public class AuthorizationCodeFlow
extends AbstractAuthorizationCodeFlow {
    private final String clientSecret;

    AuthorizationCodeFlow(String clientId, String clientSecret, String redirectUri, TokenStore tokenStore, HttpUrl tokenApiBaseUrl) {
        super(clientId, redirectUri, tokenStore, tokenApiBaseUrl);
        this.clientSecret = clientSecret;
    }

    public AuthorizationCodeFlow(String clientId, String clientSecret, String redirectUri, TokenStore tokenStore) {
        super(clientId, redirectUri, tokenStore);
        this.clientSecret = clientSecret;
    }

    public AuthorizationCodeFlow(String clientId, String clientSecret, String redirectUri) {
        super(clientId, redirectUri);
        this.clientSecret = clientSecret;
    }

    public AuthorizationUrlBuilder createAuthorizationUrl() {
        return new AuthorizationUrlBuilder(this.clientId, this.redirectUri, "code");
    }

    public void exchangeAuthorizationCode(AuthorizationRedirectResponse<String> authResponse) throws SpotifyAuthorizationException {
        if (!authResponse.isSuccess()) {
            throw new SpotifyAuthorizationException("Authorization failed: " + authResponse.getState());
        }
        ApiCall<AuthTokens> tokensCall = this.tokenApi.getTokensFromAuthorizationCode(this.createTokensCallAuthHeader(), "authorization_code", authResponse.getBody(), this.redirectUri);
        this.executeAuthTokensCall(tokensCall);
    }

    @Override
    public boolean refreshAccessToken() {
        AuthTokens tokens = this.tokenStore.loadTokens();
        if (tokens == null || !TextUtil.hasText(tokens.getRefreshToken())) {
            return false;
        }
        ApiCall<AuthTokens> tokensCall = this.tokenApi.getTokensFromRefreshToken(this.createTokensCallAuthHeader(), "refresh_token", tokens.getRefreshToken());
        try {
            this.executeAuthTokensCall(tokensCall);
            return true;
        }
        catch (SpotifyAuthorizationException ignore) {
            return false;
        }
    }

    private String createTokensCallAuthHeader() {
        String clientInfo = this.clientId + ":" + this.clientSecret;
        String base64ClientInfo = Base64.getEncoder().encodeToString(clientInfo.getBytes());
        return "Basic " + base64ClientInfo;
    }
}

