/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.authorization;

import de.sonallux.spotify.api.authorization.Scope;
import java.util.Arrays;
import okhttp3.HttpUrl;

public class AuthorizationUrlBuilder {
    protected final HttpUrl.Builder builder;

    public AuthorizationUrlBuilder(String clientId, String redirectUri, String responseType) {
        this.builder = new HttpUrl.Builder().scheme("https").host("accounts.spotify.com").addPathSegment("authorize").addQueryParameter("client_id", clientId).addQueryParameter("response_type", responseType).addQueryParameter("redirect_uri", redirectUri);
    }

    public AuthorizationUrlBuilder state(String state) {
        this.builder.addQueryParameter("state", state);
        return this;
    }

    public AuthorizationUrlBuilder scopes(Scope ... scopes) {
        if (scopes.length == 0) {
            return this;
        }
        String scopeString = Arrays.stream(scopes).map(Scope::getName).reduce((scope1, scope2) -> scope1 + " " + scope2).orElse("");
        this.builder.addQueryParameter("scope", scopeString);
        return this;
    }

    public AuthorizationUrlBuilder showDialog(boolean showDialog) {
        this.builder.addQueryParameter("show_dialog", String.valueOf(showDialog));
        return this;
    }

    public HttpUrl build() {
        return this.builder.build();
    }
}

