/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.playlists;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.SnapshotId;

public class ReorderPlaylistsTracksRequest {
    private static final TypeReference<SnapshotId> RESPONSE_TYPE = new TypeReference<SnapshotId>(){};
    private final ApiClient apiClient;
    private final Request request;

    public ReorderPlaylistsTracksRequest(ApiClient apiClient, String playlistId, int rangeStart, int insertBefore) {
        this.apiClient = apiClient;
        this.request = new Request("PUT", "/playlists/{playlist_id}/tracks").addPathParameter("playlist_id", String.valueOf(playlistId)).addBodyParameter("range_start", rangeStart).addBodyParameter("insert_before", insertBefore);
    }

    public ReorderPlaylistsTracksRequest rangeLength(int rangeLength) {
        this.request.addBodyParameter("range_length", rangeLength);
        return this;
    }

    public ReorderPlaylistsTracksRequest snapshotId(String snapshotId) {
        this.request.addBodyParameter("snapshot_id", snapshotId);
        return this;
    }

    public ApiCall<SnapshotId> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

