/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.playlists;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.Paging;
import de.sonallux.spotify.api.models.PlaylistTrack;

public class GetPlaylistsTracksRequest {
    private static final TypeReference<Paging<PlaylistTrack>> RESPONSE_TYPE = new TypeReference<Paging<PlaylistTrack>>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetPlaylistsTracksRequest(ApiClient apiClient, String playlistId) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/playlists/{playlist_id}/tracks").addPathParameter("playlist_id", String.valueOf(playlistId));
        this.additionalTypes("track,episode");
    }

    public GetPlaylistsTracksRequest market(String market) {
        this.request.addQueryParameter("market", String.valueOf(market));
        return this;
    }

    public GetPlaylistsTracksRequest fields(String fields) {
        this.request.addQueryParameter("fields", String.valueOf(fields));
        return this;
    }

    public GetPlaylistsTracksRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public GetPlaylistsTracksRequest offset(int offset) {
        this.request.addQueryParameter("offset", String.valueOf(offset));
        return this;
    }

    public GetPlaylistsTracksRequest additionalTypes(String additionalTypes) {
        this.request.addQueryParameter("additional_types", String.valueOf(additionalTypes));
        return this;
    }

    public ApiCall<Paging<PlaylistTrack>> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

