/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.playlists;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.Playlist;

public class GetPlaylistRequest {
    private static final TypeReference<Playlist> RESPONSE_TYPE = new TypeReference<Playlist>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetPlaylistRequest(ApiClient apiClient, String playlistId) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/playlists/{playlist_id}").addPathParameter("playlist_id", String.valueOf(playlistId));
        this.additionalTypes("track,episode");
    }

    public GetPlaylistRequest market(String market) {
        this.request.addQueryParameter("market", String.valueOf(market));
        return this;
    }

    public GetPlaylistRequest fields(String fields) {
        this.request.addQueryParameter("fields", String.valueOf(fields));
        return this;
    }

    public GetPlaylistRequest additionalTypes(String additionalTypes) {
        this.request.addQueryParameter("additional_types", String.valueOf(additionalTypes));
        return this;
    }

    public ApiCall<Playlist> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

