/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.player;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import java.util.List;
import java.util.Map;

public class StartUsersPlaybackRequest {
    private static final TypeReference<Void> RESPONSE_TYPE = new TypeReference<Void>(){};
    private final ApiClient apiClient;
    private final Request request;

    public StartUsersPlaybackRequest(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.request = new Request("PUT", "/me/player/play");
    }

    public StartUsersPlaybackRequest deviceId(String deviceId) {
        this.request.addQueryParameter("device_id", String.valueOf(deviceId));
        return this;
    }

    public StartUsersPlaybackRequest contextUri(String contextUri) {
        this.request.addBodyParameter("context_uri", contextUri);
        return this;
    }

    public StartUsersPlaybackRequest uris(List<String> uris) {
        this.request.addBodyParameter("uris", uris);
        return this;
    }

    public StartUsersPlaybackRequest offset(Map<String, Object> offset) {
        this.request.addBodyParameter("offset", offset);
        return this;
    }

    public StartUsersPlaybackRequest positionMs(int positionMs) {
        this.request.addBodyParameter("position_ms", positionMs);
        return this;
    }

    public ApiCall<Void> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

