/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.personalization;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.Artist;
import de.sonallux.spotify.api.models.Paging;

public class GetUsersTopArtistsRequest {
    private static final TypeReference<Paging<Artist>> RESPONSE_TYPE = new TypeReference<Paging<Artist>>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetUsersTopArtistsRequest(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/me/top/artists");
    }

    public GetUsersTopArtistsRequest timeRange(String timeRange) {
        this.request.addQueryParameter("time_range", String.valueOf(timeRange));
        return this;
    }

    public GetUsersTopArtistsRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public GetUsersTopArtistsRequest offset(int offset) {
        this.request.addQueryParameter("offset", String.valueOf(offset));
        return this;
    }

    public ApiCall<Paging<Artist>> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

