/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.library;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.Paging;
import de.sonallux.spotify.api.models.SavedTrack;

public class GetUsersSavedTracksRequest {
    private static final TypeReference<Paging<SavedTrack>> RESPONSE_TYPE = new TypeReference<Paging<SavedTrack>>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetUsersSavedTracksRequest(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/me/tracks");
    }

    public GetUsersSavedTracksRequest market(String market) {
        this.request.addQueryParameter("market", String.valueOf(market));
        return this;
    }

    public GetUsersSavedTracksRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public GetUsersSavedTracksRequest offset(int offset) {
        this.request.addQueryParameter("offset", String.valueOf(offset));
        return this;
    }

    public ApiCall<Paging<SavedTrack>> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

