/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.browse;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.FeaturedPlaylist;

public class GetFeaturedPlaylistsRequest {
    private static final TypeReference<FeaturedPlaylist> RESPONSE_TYPE = new TypeReference<FeaturedPlaylist>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetFeaturedPlaylistsRequest(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/browse/featured-playlists");
    }

    public GetFeaturedPlaylistsRequest country(String country) {
        this.request.addQueryParameter("country", String.valueOf(country));
        return this;
    }

    public GetFeaturedPlaylistsRequest locale(String locale) {
        this.request.addQueryParameter("locale", String.valueOf(locale));
        return this;
    }

    public GetFeaturedPlaylistsRequest timestamp(String timestamp) {
        this.request.addQueryParameter("timestamp", String.valueOf(timestamp));
        return this;
    }

    public GetFeaturedPlaylistsRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public GetFeaturedPlaylistsRequest offset(int offset) {
        this.request.addQueryParameter("offset", String.valueOf(offset));
        return this;
    }

    public ApiCall<FeaturedPlaylist> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

