/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.browse;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.PlaylistPaging;

public class GetCategoriesPlaylistsRequest {
    private static final TypeReference<PlaylistPaging> RESPONSE_TYPE = new TypeReference<PlaylistPaging>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetCategoriesPlaylistsRequest(ApiClient apiClient, String categoryId) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/browse/categories/{category_id}/playlists").addPathParameter("category_id", String.valueOf(categoryId));
    }

    public GetCategoriesPlaylistsRequest country(String country) {
        this.request.addQueryParameter("country", String.valueOf(country));
        return this;
    }

    public GetCategoriesPlaylistsRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public GetCategoriesPlaylistsRequest offset(int offset) {
        this.request.addQueryParameter("offset", String.valueOf(offset));
        return this;
    }

    public ApiCall<PlaylistPaging> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

