/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.util;

import de.sonallux.spotify.api.util.SpotifyUriException;

public class SpotifyUri {
    private final Type type;
    private final String id;

    public boolean isArtist() {
        return this.type == Type.ARTIST;
    }

    public String getArtistId() throws SpotifyUriException {
        if (this.isArtist()) {
            return this.id;
        }
        throw new SpotifyUriException("SpotifyUri does not contain an artist id");
    }

    public boolean isAlbum() {
        return this.type == Type.ALBUM;
    }

    public String getAlbumId() throws SpotifyUriException {
        if (this.isAlbum()) {
            return this.id;
        }
        throw new SpotifyUriException("SpotifyUri does not contain an album id");
    }

    public boolean isEpisode() {
        return this.type == Type.EPISODE;
    }

    public String getEpisodeId() throws SpotifyUriException {
        if (this.isEpisode()) {
            return this.id;
        }
        throw new SpotifyUriException("SpotifyUri does not contain an episode id");
    }

    public boolean isPlaylist() {
        return this.type == Type.PLAYLIST;
    }

    public String getPlaylistId() throws SpotifyUriException {
        if (this.isPlaylist()) {
            return this.id;
        }
        throw new SpotifyUriException("SpotifyUri does not contain a playlist id");
    }

    public boolean isShow() {
        return this.type == Type.SHOW;
    }

    public String getShowId() throws SpotifyUriException {
        if (this.isShow()) {
            return this.id;
        }
        throw new SpotifyUriException("SpotifyUri does not contain a show id");
    }

    public boolean isTrack() {
        return this.type == Type.TRACK;
    }

    public String getTrackId() throws SpotifyUriException {
        if (this.isTrack()) {
            return this.id;
        }
        throw new SpotifyUriException("SpotifyUri does not contain a track id");
    }

    public boolean isUser() {
        return this.type == Type.USER;
    }

    public String getUserId() throws SpotifyUriException {
        if (this.isUser()) {
            return this.id;
        }
        throw new SpotifyUriException("SpotifyUri does not contain a user id");
    }

    public String toSpotifyUri() {
        return "spotify:" + this.type.name().toLowerCase() + ":" + this.id;
    }

    public String toString() {
        return this.toSpotifyUri();
    }

    public static SpotifyUri parseUri(String string) throws SpotifyUriException {
        if (string == null || string.length() == 0) {
            throw new SpotifyUriException("Can not parse empty spotifyUri");
        }
        String[] parts = string.split(":");
        if (parts.length != 3) {
            throw new SpotifyUriException("SpotifyUri has wrong format: " + string);
        }
        if (!"spotify".equals(parts[0])) {
            throw new SpotifyUriException("SpotifyUri must start with 'spotify'");
        }
        try {
            Type type = Type.get(parts[1]);
            return new SpotifyUri(type, parts[2]);
        }
        catch (IllegalArgumentException e) {
            throw new SpotifyUriException("Spotify URI has unknown type: " + parts[1]);
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public SpotifyUri(Type type, String id) {
        this.type = type;
        this.id = id;
    }

    public static enum Type {
        ARTIST,
        ALBUM,
        EPISODE,
        PLAYLIST,
        SHOW,
        TRACK,
        USER;


        public static Type get(String name) {
            return Type.valueOf(name.toUpperCase());
        }
    }
}

