/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.sonallux.spotify.api.http.ApiClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;

public class Request {
    private static final MediaType JSON_MEDIA_TYPE = MediaType.get((String)"application/json; charset=UTF-8");
    private final String method;
    private final String path;
    private final Map<String, String> pathParameter = new HashMap<String, String>();
    private final Map<String, String> queryParameters = new LinkedHashMap<String, String>();
    private final Map<String, String> headerParameters = new LinkedHashMap<String, String>();
    private final Map<String, Object> bodyParameters = new LinkedHashMap<String, Object>();
    private final Map<String, String> formParameters = new LinkedHashMap<String, String>();
    private Optional<RequestBody> rawBody = Optional.empty();

    public Request addPathParameter(String key, String value) {
        this.pathParameter.put(key, value);
        return this;
    }

    public Request addQueryParameter(String key, String value) {
        this.queryParameters.put(key, value);
        return this;
    }

    public Request addHeaderParameter(String key, String value) {
        this.headerParameters.put(key, value);
        return this;
    }

    public Request addBodyParameter(String key, Object value) {
        this.bodyParameters.put(key, value);
        return this;
    }

    public Request addFormUrlEncodedField(String key, String value) {
        this.formParameters.put(key, value);
        return this;
    }

    public Request withRawBody(RequestBody rawBody) {
        this.rawBody = Optional.of(rawBody);
        return this;
    }

    Request.Builder toOkHttpRequest(ApiClient apiClient) throws IOException {
        RequestBody requestBody = this.createRequestBody(apiClient.getObjectMapper());
        if (requestBody == null && HttpMethod.requiresRequestBody((String)this.getMethod())) {
            requestBody = RequestBody.create((byte[])new byte[0]);
        }
        return new Request.Builder().url(this.createFullUrl(apiClient.getBaseUrl())).method(this.getMethod(), requestBody).headers(Headers.of(this.getHeaderParameters()));
    }

    private RequestBody createRequestBody(ObjectMapper objectMapper) throws IOException {
        if (this.rawBody.isPresent()) {
            return this.rawBody.get();
        }
        if (this.getBodyParameters().size() > 0 && this.getFormParameters().size() > 0) {
            throw new IllegalArgumentException("Can not use body parameters and form fields in one request");
        }
        if (this.getBodyParameters().size() > 0) {
            byte[] bytes = objectMapper.writeValueAsBytes(this.getBodyParameters());
            return RequestBody.create((byte[])bytes, (MediaType)JSON_MEDIA_TYPE);
        }
        if (this.getFormParameters().size() > 0) {
            FormBody.Builder formBuilder = new FormBody.Builder();
            this.getFormParameters().forEach((arg_0, arg_1) -> ((FormBody.Builder)formBuilder).add(arg_0, arg_1));
            return formBuilder.build();
        }
        return null;
    }

    private HttpUrl createFullUrl(HttpUrl baseUrl) {
        String relativeUrl = this.getPath();
        for (Map.Entry<String, String> entry : this.getPathParameter().entrySet()) {
            relativeUrl = relativeUrl.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        if (relativeUrl.startsWith("/")) {
            relativeUrl = relativeUrl.substring(1);
        }
        HttpUrl.Builder urlBuilder = baseUrl.newBuilder();
        if (!relativeUrl.isBlank()) {
            urlBuilder.addPathSegments(relativeUrl);
        }
        for (Map.Entry<String, String> entry : this.getQueryParameters().entrySet()) {
            urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
        }
        return urlBuilder.build();
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getPathParameter() {
        return this.pathParameter;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, String> getHeaderParameters() {
        return this.headerParameters;
    }

    public Map<String, Object> getBodyParameters() {
        return this.bodyParameters;
    }

    public Map<String, String> getFormParameters() {
        return this.formParameters;
    }

    public Optional<RequestBody> getRawBody() {
        return this.rawBody;
    }

    public Request(String method, String path) {
        this.method = method;
        this.path = path;
    }
}

