/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.http;

import de.sonallux.spotify.api.authorization.ApiAuthorizationProvider;
import de.sonallux.spotify.api.util.TextUtil;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class AuthorizationAddingInterceptor
implements Interceptor {
    private final ApiAuthorizationProvider authProvider;

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        String authorizationHeaderValue = this.authProvider.getAuthorizationHeaderValue();
        if (TextUtil.hasText(authorizationHeaderValue)) {
            request = request.newBuilder().addHeader("Authorization", authorizationHeaderValue).build();
        }
        return chain.proceed(request);
    }

    public AuthorizationAddingInterceptor(ApiAuthorizationProvider authProvider) {
        this.authProvider = authProvider;
    }
}

