/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.Request;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class ApiClient {
    private final HttpUrl baseUrl;
    private final Call.Factory callFactory;
    private final ObjectMapper objectMapper;
    private final ApiCall.Factory apiCallFactory;

    public <T> ApiCall<T> createApiCall(Request request, TypeReference<T> responseType) {
        return this.apiCallFactory.createApiCall(this, request, responseType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public HttpUrl getBaseUrl() {
        return this.baseUrl;
    }

    public Call.Factory getCallFactory() {
        return this.callFactory;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public ApiCall.Factory getApiCallFactory() {
        return this.apiCallFactory;
    }

    ApiClient(HttpUrl baseUrl, Call.Factory callFactory, ObjectMapper objectMapper, ApiCall.Factory apiCallFactory) {
        this.baseUrl = baseUrl;
        this.callFactory = callFactory;
        this.objectMapper = objectMapper;
        this.apiCallFactory = apiCallFactory;
    }

    public static final class Builder {
        private HttpUrl baseUrl;
        private Call.Factory callFactory;
        private ObjectMapper objectMapper;
        private ApiCall.Factory apiCallFactory;

        public Builder baseUrl(String baseUrl) {
            Objects.requireNonNull(baseUrl, "baseUrl == null");
            return this.baseUrl(HttpUrl.get((String)baseUrl));
        }

        public Builder baseUrl(HttpUrl baseUrl) {
            this.baseUrl = Objects.requireNonNull(baseUrl, "baseUrl == null");
            return this;
        }

        public Builder httpClient(OkHttpClient httpClient) {
            return this.callFactory((Call.Factory)Objects.requireNonNull(httpClient, "httpClient == null"));
        }

        public Builder callFactory(Call.Factory factory) {
            this.callFactory = Objects.requireNonNull(factory, "factory == null");
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper == null");
            return this;
        }

        public Builder apiCallFactory(ApiCall.Factory apiCallFactory) {
            this.apiCallFactory = Objects.requireNonNull(apiCallFactory, "apiCallFactory == null");
            return this;
        }

        public ApiClient build() {
            if (this.baseUrl == null) {
                throw new IllegalStateException("Base URL required.");
            }
            if (this.objectMapper == null) {
                this.objectMapper = new ObjectMapper();
            }
            if (this.callFactory == null) {
                this.callFactory = new OkHttpClient();
            }
            if (this.apiCallFactory == null) {
                this.apiCallFactory = new ApiCall.Factory();
            }
            return new ApiClient(this.baseUrl, this.callFactory, this.objectMapper, this.apiCallFactory);
        }
    }
}

