/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.http;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.SpotifyApiException;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.http.Response;
import de.sonallux.spotify.api.models.Error;
import de.sonallux.spotify.api.models.ErrorResponse;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

public class ApiCall<T> {
    private static final TypeReference<ErrorResponse> ERROR_RESPONSE_TYPE = new TypeReference<ErrorResponse>(){};
    private final ApiClient apiClient;
    private final Request request;
    private final TypeReference<T> responseType;
    private volatile boolean canceled;
    private Call rawCall;
    private Throwable creationFailure;
    private boolean executed;

    protected Call getRawCall() throws IOException {
        if (this.rawCall != null) {
            return this.rawCall;
        }
        if (this.creationFailure != null) {
            if (this.creationFailure instanceof IOException) {
                throw (IOException)this.creationFailure;
            }
            throw (RuntimeException)this.creationFailure;
        }
        try {
            okhttp3.Request rawRequest = this.request.toOkHttpRequest(this.apiClient).build();
            this.rawCall = this.apiClient.getCallFactory().newCall(rawRequest);
            return this.rawCall;
        }
        catch (IOException | RuntimeException e) {
            this.creationFailure = e;
            throw e;
        }
    }

    public synchronized boolean isExecuted() {
        return this.executed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response<T> executeCall() throws IOException {
        Call call;
        ApiCall apiCall = this;
        synchronized (apiCall) {
            if (this.executed) {
                throw new IllegalStateException("Already executed.");
            }
            this.executed = true;
            call = this.getRawCall();
        }
        if (this.canceled) {
            call.cancel();
        }
        return this.parseResponse(call.execute());
    }

    public T execute() throws SpotifyApiException {
        Response<T> response;
        try {
            response = this.executeCall();
        }
        catch (IOException e) {
            throw new SpotifyApiException("Failed to make api call", e);
        }
        if (response.isSuccessful()) {
            return response.body();
        }
        throw new SpotifyApiException("Api call failed", response.errorBody());
    }

    protected Response<T> parseResponse(okhttp3.Response rawResponse) throws IOException {
        Error error;
        ResponseBody rawBody;
        block12: {
            rawBody = rawResponse.body();
            if (rawResponse.isSuccessful()) {
                int code = rawResponse.code();
                if (this.responseType.getType() == Void.class || code == 204 || code == 205) {
                    Response<Object> response = Response.success(null, rawResponse);
                    return response;
                }
                ExceptionCatchingResponseBody catchingBody = new ExceptionCatchingResponseBody(rawBody);
                try {
                    T body = this.parseResponseBody(catchingBody, this.responseType);
                    Response<T> response = Response.success(body, rawResponse);
                    return response;
                }
                catch (RuntimeException e) {
                    catchingBody.throwIfCaught();
                    throw e;
                }
            }
            error = this.getErrorBody(rawBody);
            if (error != null) break block12;
            error = this.getErrorDetailsFromResponse(rawResponse);
        }
        Response response = Response.error(error, rawResponse);
        return response;
        finally {
            if (rawBody != null) {
                rawBody.close();
            }
        }
    }

    private <RT> RT parseResponseBody(ResponseBody responseBody, TypeReference<RT> responseType) throws IOException {
        try (ResponseBody responseBody2 = responseBody;){
            Object object = this.apiClient.getObjectMapper().readValue(responseBody.byteStream(), responseType);
            return (RT)object;
        }
    }

    private Error getErrorBody(ResponseBody rawResponse) {
        if (rawResponse.contentLength() == 0L) {
            return null;
        }
        try {
            ErrorResponse errorResponse = this.parseResponseBody(rawResponse, ERROR_RESPONSE_TYPE);
            if (errorResponse != null) {
                return errorResponse.getError();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private Error getErrorDetailsFromResponse(okhttp3.Response response) {
        Error error = new Error();
        error.setStatus(response.code());
        error.setMessage(response.message());
        return error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Call call;
        this.canceled = true;
        ApiCall apiCall = this;
        synchronized (apiCall) {
            call = this.rawCall;
        }
        if (call != null) {
            call.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        if (this.canceled) {
            return true;
        }
        ApiCall apiCall = this;
        synchronized (apiCall) {
            return this.rawCall != null && this.rawCall.isCanceled();
        }
    }

    ApiCall(ApiClient apiClient, Request request, TypeReference<T> responseType) {
        this.apiClient = apiClient;
        this.request = request;
        this.responseType = responseType;
    }

    public static class Factory {
        public <T> ApiCall<T> createApiCall(ApiClient apiClient, Request request, TypeReference<T> responseType) {
            return new ApiCall<T>(apiClient, request, responseType);
        }
    }

    static final class ExceptionCatchingResponseBody
    extends ResponseBody {
        private final ResponseBody delegate;
        private final BufferedSource delegateSource;
        private IOException thrownException;

        ExceptionCatchingResponseBody(ResponseBody delegate) {
            this.delegate = delegate;
            this.delegateSource = Okio.buffer((Source)new ForwardingSource((Source)delegate.source()){

                public long read(@NotNull Buffer sink, long byteCount) throws IOException {
                    try {
                        return super.read(sink, byteCount);
                    }
                    catch (IOException e) {
                        thrownException = e;
                        throw e;
                    }
                }
            });
        }

        public MediaType contentType() {
            return this.delegate.contentType();
        }

        public long contentLength() {
            return this.delegate.contentLength();
        }

        @NotNull
        public BufferedSource source() {
            return this.delegateSource;
        }

        public void close() {
            this.delegate.close();
        }

        void throwIfCaught() throws IOException {
            if (this.thrownException != null) {
                throw this.thrownException;
            }
        }
    }
}

