/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.authorization.client_credentials;

import de.sonallux.spotify.api.SpotifyApiException;
import de.sonallux.spotify.api.authorization.AuthTokens;
import de.sonallux.spotify.api.authorization.InMemoryTokenStore;
import de.sonallux.spotify.api.authorization.SpotifyAuthorizationException;
import de.sonallux.spotify.api.authorization.TokenStore;
import de.sonallux.spotify.api.authorization.TokenStoreApiAuthorizationProvider;
import de.sonallux.spotify.api.authorization.client_credentials.AuthorizationTokenApi;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import java.util.Base64;
import okhttp3.HttpUrl;

public class ClientCredentialsFlow
extends TokenStoreApiAuthorizationProvider {
    private final String clientId;
    private final String clientSecret;
    private final AuthorizationTokenApi tokenApi;

    ClientCredentialsFlow(String clientId, String clientSecret, TokenStore tokenStore, HttpUrl tokenApiBaseUrl) {
        super(tokenStore);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        ApiClient apiClient = ClientCredentialsFlow.createApiClient(tokenApiBaseUrl);
        this.tokenApi = new AuthorizationTokenApi(apiClient);
    }

    public ClientCredentialsFlow(String clientId, String clientSecret) {
        this(clientId, clientSecret, new InMemoryTokenStore(), AuthorizationTokenApi.BASE_URL);
    }

    private static ApiClient createApiClient(HttpUrl tokenApiBaseUrl) {
        return ApiClient.builder().baseUrl(tokenApiBaseUrl).build();
    }

    public void authorize() throws SpotifyAuthorizationException {
        ApiCall<AuthTokens> authTokensCall = this.tokenApi.getAuthTokens(this.createTokensCallAuthHeader(), "client_credentials");
        try {
            AuthTokens authTokens = authTokensCall.execute();
            this.tokenStore.storeTokens(authTokens);
        }
        catch (SpotifyApiException e) {
            throw new SpotifyAuthorizationException("Failed to get auth tokens", e);
        }
    }

    private String createTokensCallAuthHeader() {
        String clientInfo = this.clientId + ":" + this.clientSecret;
        String base64ClientInfo = Base64.getEncoder().encodeToString(clientInfo.getBytes());
        return "Basic " + base64ClientInfo;
    }
}

