/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.authorization.authorization_code;

import de.sonallux.spotify.api.SpotifyApiException;
import de.sonallux.spotify.api.authorization.AuthTokens;
import de.sonallux.spotify.api.authorization.AuthorizationRedirectResponse;
import de.sonallux.spotify.api.authorization.InMemoryTokenStore;
import de.sonallux.spotify.api.authorization.SpotifyAuthorizationException;
import de.sonallux.spotify.api.authorization.TokenStore;
import de.sonallux.spotify.api.authorization.TokenStoreApiAuthorizationProvider;
import de.sonallux.spotify.api.authorization.authorization_code.AuthorizationCodeTokenApi;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.util.TextUtil;
import okhttp3.HttpUrl;

abstract class AbstractAuthorizationCodeFlow
extends TokenStoreApiAuthorizationProvider {
    final String clientId;
    final String redirectUri;
    final AuthorizationCodeTokenApi tokenApi;

    AbstractAuthorizationCodeFlow(String clientId, String redirectUri, TokenStore tokenStore, HttpUrl tokenApiBaseUrl) {
        super(tokenStore);
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        ApiClient apiClient = AbstractAuthorizationCodeFlow.createApiClient(tokenApiBaseUrl);
        this.tokenApi = new AuthorizationCodeTokenApi(apiClient);
    }

    AbstractAuthorizationCodeFlow(String clientId, String redirectUri, TokenStore tokenStore) {
        this(clientId, redirectUri, tokenStore, AuthorizationCodeTokenApi.BASE_URL);
    }

    AbstractAuthorizationCodeFlow(String clientId, String redirectUri) {
        this(clientId, redirectUri, new InMemoryTokenStore());
    }

    private static ApiClient createApiClient(HttpUrl tokenApiBaseUrl) {
        return ApiClient.builder().baseUrl(tokenApiBaseUrl).build();
    }

    public AuthorizationRedirectResponse<String> parseAuthorizationRedirectResponse(String url) {
        return AuthorizationRedirectResponse.parse(url, httpUrl -> {
            String code = httpUrl.queryParameter("code");
            if (TextUtil.hasText(code)) {
                return code;
            }
            return null;
        });
    }

    void executeAuthTokensCall(ApiCall<AuthTokens> authTokensCall) throws SpotifyAuthorizationException {
        try {
            AuthTokens authTokens = authTokensCall.execute();
            this.tokenStore.storeTokens(authTokens);
        }
        catch (SpotifyApiException e) {
            throw new SpotifyAuthorizationException("Failed to get auth tokens", e);
        }
    }
}

