/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.authorization;

import de.sonallux.spotify.api.util.TextUtil;
import java.util.function.Function;
import okhttp3.HttpUrl;

public class AuthorizationRedirectResponse<T> {
    private final String state;
    private final T body;
    private final String error;

    public boolean isSuccess() {
        return this.body != null;
    }

    public static <T> AuthorizationRedirectResponse<T> success(T body, String state) {
        return new AuthorizationRedirectResponse<T>(state, body, null);
    }

    public static <T> AuthorizationRedirectResponse<T> success(T body) {
        return new AuthorizationRedirectResponse<T>(null, body, null);
    }

    public static <T> AuthorizationRedirectResponse<T> error(String error, String state) {
        return new AuthorizationRedirectResponse<Object>(state, null, error);
    }

    public static <T> AuthorizationRedirectResponse<T> error(String error) {
        return new AuthorizationRedirectResponse<Object>(null, null, error);
    }

    public static <T> AuthorizationRedirectResponse<T> parse(String url, Function<HttpUrl, T> contentExtractor) {
        return AuthorizationRedirectResponse.parse(HttpUrl.get((String)url), contentExtractor);
    }

    public static <T> AuthorizationRedirectResponse<T> parse(HttpUrl httpUrl, Function<HttpUrl, T> contentExtractor) {
        String state = httpUrl.queryParameter("state");
        String error = httpUrl.queryParameter("error");
        T content = contentExtractor.apply(httpUrl);
        if (content != null) {
            return new AuthorizationRedirectResponse<T>(state, content, null);
        }
        if (TextUtil.hasText(error)) {
            return new AuthorizationRedirectResponse<Object>(state, null, error);
        }
        return new AuthorizationRedirectResponse<Object>(state, null, "Invalid authorization redirect response uri");
    }

    public String getState() {
        return this.state;
    }

    public T getBody() {
        return this.body;
    }

    public String getError() {
        return this.error;
    }

    private AuthorizationRedirectResponse(String state, T body, String error) {
        this.state = state;
        this.body = body;
        this.error = error;
    }
}

