/*
 * Decompiled with CFR 0.152.
 */
package de.sonallux.spotify.api.apis.shows;

import com.fasterxml.jackson.core.type.TypeReference;
import de.sonallux.spotify.api.http.ApiCall;
import de.sonallux.spotify.api.http.ApiClient;
import de.sonallux.spotify.api.http.Request;
import de.sonallux.spotify.api.models.Paging;
import de.sonallux.spotify.api.models.SimplifiedEpisode;

public class GetShowsEpisodesRequest {
    private static final TypeReference<Paging<SimplifiedEpisode>> RESPONSE_TYPE = new TypeReference<Paging<SimplifiedEpisode>>(){};
    private final ApiClient apiClient;
    private final Request request;

    public GetShowsEpisodesRequest(ApiClient apiClient, String id) {
        this.apiClient = apiClient;
        this.request = new Request("GET", "/shows/{id}/episodes").addPathParameter("id", String.valueOf(id));
    }

    public GetShowsEpisodesRequest market(String market) {
        this.request.addQueryParameter("market", String.valueOf(market));
        return this;
    }

    public GetShowsEpisodesRequest limit(int limit) {
        this.request.addQueryParameter("limit", String.valueOf(limit));
        return this;
    }

    public GetShowsEpisodesRequest offset(int offset) {
        this.request.addQueryParameter("offset", String.valueOf(offset));
        return this;
    }

    public ApiCall<Paging<SimplifiedEpisode>> build() {
        return this.apiClient.createApiCall(this.request, RESPONSE_TYPE);
    }
}

